/*
 * Decompiled with CFR 0.152.
 */
package access.model;

import access.model.RemoteIdentifier;
import access.model.Role;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.ManyToOne;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;

@Entity(name="remote_provisioned_groups")
public class RemoteProvisionedGroup
implements Serializable,
RemoteIdentifier {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    private Role role;
    @Column(name="remote_scim_identifier")
    @NotNull
    private String remoteScimIdentifier;
    @Column(name="manage_provisioning_id")
    @NotNull
    private String manageProvisioningId;

    public RemoteProvisionedGroup(Role role, @NotNull String remoteScimIdentifier, @NotNull String manageProvisioningId) {
        this.role = role;
        this.remoteScimIdentifier = remoteScimIdentifier;
        this.manageProvisioningId = manageProvisioningId;
    }

    public String getRemoteIdentifier() {
        return this.remoteScimIdentifier;
    }

    public RemoteProvisionedGroup() {
    }

    public Long getId() {
        return this.id;
    }

    public Role getRole() {
        return this.role;
    }

    public String getRemoteScimIdentifier() {
        return this.remoteScimIdentifier;
    }

    public String getManageProvisioningId() {
        return this.manageProvisioningId;
    }
}

