/*
 * Decompiled with CFR 0.152.
 */
package access.provision.scim;

import access.model.User;
import access.provision.Provisioning;
import access.provision.ScimUserIdentifier;
import access.provision.scim.Email;
import access.provision.scim.Name;
import access.provision.scim.UserRequest;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.springframework.util.StringUtils;

public class UserRequest
implements Serializable {
    private final List<String> schemas = Collections.singletonList("urn:ietf:params:scim:schemas:core:2.0:User");
    private final String externalId;
    private final String userName;
    private final Name name;
    private String id;
    private final String displayName;
    private final List<Email> emails;

    public UserRequest(User user, Provisioning provisioning) {
        this.externalId = this.resolveExternalId(user, provisioning);
        this.userName = user.getEduPersonPrincipalName();
        this.name = new Name(user.getName(), user.getFamilyName(), user.getGivenName());
        this.displayName = user.getName();
        this.emails = Collections.singletonList(new Email(user.getEmail()));
    }

    public UserRequest(User user, Provisioning provisioning, String remoteScimIdentifier) {
        this(user, provisioning);
        this.id = remoteScimIdentifier;
    }

    private String resolveExternalId(User user, Provisioning provisioning) {
        ScimUserIdentifier scimUserIdentifier = provisioning.getScimUserIdentifier();
        String defaultExternalId = user.getEduPersonPrincipalName();
        if (scimUserIdentifier == null) {
            return defaultExternalId;
        }
        return switch (1.$SwitchMap$access$provision$ScimUserIdentifier[scimUserIdentifier.ordinal()]) {
            case 1 -> {
                if (StringUtils.hasText((String)user.getSubjectId())) {
                    yield user.getSubjectId();
                }
                yield defaultExternalId;
            }
            case 2 -> {
                if (StringUtils.hasText((String)user.getUid())) {
                    yield user.getUid();
                }
                yield defaultExternalId;
            }
            case 3 -> {
                if (StringUtils.hasText((String)user.getEmail())) {
                    yield user.getEmail();
                }
                yield defaultExternalId;
            }
            case 4 -> {
                if (StringUtils.hasText((String)user.getEduId())) {
                    yield user.getEduId();
                }
                yield defaultExternalId;
            }
            default -> defaultExternalId;
        };
    }

    public List<String> getSchemas() {
        return this.schemas;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public String getUserName() {
        return this.userName;
    }

    public Name getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public List<Email> getEmails() {
        return this.emails;
    }
}

