/*
 * Decompiled with CFR 0.152.
 */
package access.teams;

import access.api.Results;
import access.exception.InvalidInputException;
import access.manage.Manage;
import access.model.Application;
import access.model.ApplicationUsage;
import access.model.Authority;
import access.model.User;
import access.model.UserRole;
import access.provision.ProvisioningService;
import access.provision.scim.GroupURN;
import access.provision.scim.OperationType;
import access.repository.ApplicationRepository;
import access.repository.RoleRepository;
import access.repository.UserRepository;
import access.repository.UserRoleRepository;
import access.teams.Membership;
import access.teams.Person;
import access.teams.Role;
import access.teams.Team;
import access.teams.TeamsController;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(value={"/api/teams", "/api/external/v1/teams"}, produces={"application/json"})
@SecurityRequirement(name="basic_auth")
public class TeamsController {
    private static final int DEFAULT_EXPIRY_DAYS = 1825;
    private final RoleRepository roleRepository;
    private final UserRepository userRepository;
    private final UserRoleRepository userRoleRepository;
    private final ApplicationRepository applicationRepository;
    private final Manage manage;
    private final ProvisioningService provisioningService;

    public TeamsController(RoleRepository roleRepository, UserRepository userRepository, UserRoleRepository userRoleRepository, ApplicationRepository applicationRepository, Manage manage, ProvisioningService provisioningService) {
        this.roleRepository = roleRepository;
        this.userRepository = userRepository;
        this.userRoleRepository = userRoleRepository;
        this.applicationRepository = applicationRepository;
        this.manage = manage;
        this.provisioningService = provisioningService;
    }

    @PutMapping(value={""})
    @PreAuthorize(value="hasRole('TEAMS')")
    @Transactional
    public ResponseEntity<Map<String, Integer>> migrateTeam(@RequestBody Team team) {
        Set applications;
        if (CollectionUtils.isEmpty((Collection)team.getApplications())) {
            throw new InvalidInputException("applications are required");
        }
        List memberships = team.getMemberships();
        if (!CollectionUtils.isEmpty((Collection)memberships)) {
            memberships.forEach(membership -> {
                if (membership.getPerson() == null) {
                    throw new InvalidInputException("person of a membership is required");
                }
                if (membership.getPerson().getSchacHomeOrganization() == null) {
                    throw new InvalidInputException("schacHomeOrganization of a person is required");
                }
            });
        }
        if ((applications = team.getApplications().stream().filter(arg_0 -> this.applicationExists(arg_0)).collect(Collectors.toSet())).isEmpty()) {
            throw new InvalidInputException("None of the applications exists in Manage");
        }
        access.model.Role role = new access.model.Role();
        role.setName(team.getName());
        role.setShortName(GroupURN.sanitizeRoleShortName((String)role.getName()));
        role.setDescription(team.getDescription());
        role.setUrn(team.getUrn());
        role.setDefaultExpiryDays(Integer.valueOf(1825));
        role.setIdentifier(UUID.randomUUID().toString());
        role.setTeamsOrigin(true);
        Set applicationUsages = team.getApplications().stream().map(applicationFromTeams -> {
            Application applicationFromDB = this.applicationRepository.findByManageIdAndManageType(applicationFromTeams.getManageId(), applicationFromTeams.getManageType()).orElseGet(() -> (Application)this.applicationRepository.save(applicationFromTeams));
            return new ApplicationUsage(applicationFromDB, applicationFromTeams.getLandingPage());
        }).collect(Collectors.toSet());
        role.setApplicationUsages(applicationUsages);
        access.model.Role savedRole = (access.model.Role)this.roleRepository.save((Object)role);
        this.provisioningService.newGroupRequest(savedRole);
        memberships.forEach(membership -> this.provision(savedRole, membership));
        return Results.createResult();
    }

    private boolean applicationExists(Application application) {
        try {
            this.manage.providerById(application.getManageType(), application.getManageId());
            return true;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    private void provision(access.model.Role role, Membership membership) {
        Instant now;
        Person person = membership.getPerson();
        Optional optionalUser = this.userRepository.findBySubIgnoreCase(person.getUrn());
        User user = optionalUser.orElseGet(() -> this.lambda$provision$4(person, now = Instant.now()));
        if (user.getCreatedAt() == null) {
            user.setCreatedAt(now);
        }
        if (user.getLastActivity() == null) {
            user.setLastActivity(now);
        }
        UserRole userRole = new UserRole();
        userRole.setInviter("teams_migration");
        userRole.setUser(user);
        userRole.setRole(role);
        userRole.setCreatedAt(now);
        userRole.setEndDate(now.plus(1825L, ChronoUnit.DAYS));
        Role teamsRole = membership.getRole();
        userRole.setAuthority(TeamsController.mapAuthority((Role)teamsRole));
        boolean guestRoleIncluded = teamsRole.equals((Object)Role.ADMIN) || teamsRole.equals((Object)Role.MANAGER);
        userRole.setGuestRoleIncluded(guestRoleIncluded);
        userRole = (UserRole)this.userRoleRepository.save((Object)userRole);
        this.provisioningService.updateGroupRequest(userRole, OperationType.Add);
    }

    protected static Authority mapAuthority(Role role) {
        switch (1.$SwitchMap$access$teams$Role[role.ordinal()]) {
            case 1: {
                return Authority.GUEST;
            }
            case 2: {
                return Authority.INVITER;
            }
            case 3: 
            case 4: {
                return Authority.MANAGER;
            }
        }
        throw new InvalidInputException("Unknown membership role: " + role);
    }

    private /* synthetic */ User lambda$provision$4(Person person, Instant now) {
        User newUser = new User();
        newUser.setSub(person.getUrn());
        newUser.setName(person.getName());
        newUser.setEmail(person.getEmail());
        newUser.setSchacHomeOrganization(person.getSchacHomeOrganization());
        newUser.setCreatedAt(now);
        newUser.setLastActivity(now);
        newUser.nameInvariant();
        return (User)this.userRepository.save((Object)newUser);
    }
}

