/*
 * Decompiled with CFR 0.152.
 */
package access.provision.eva;

import access.model.User;
import access.provision.Provisioning;
import access.provision.eva.GuestAccount;
import crypto.KeyStore;
import java.net.URI;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.util.MultiValueMap;

public class EvaClient {
    private final KeyStore keyStore;

    public EvaClient(KeyStore keyStore) {
        this.keyStore = keyStore;
    }

    public RequestEntity<String> newUserRequest(Provisioning provisioning, User user) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        String encryptedEvaToken = provisioning.getEvaToken();
        String evaToken = this.keyStore.isEncryptedSecret(encryptedEvaToken) ? this.keyStore.decodeAndDecrypt(encryptedEvaToken) : encryptedEvaToken;
        headers.add("X-Api-Key", evaToken);
        MultiValueMap map = new GuestAccount(user, provisioning).getRequest();
        String url = provisioning.getEvaUrl() + "/api/v1/guest/create";
        return new RequestEntity((Object)map, (MultiValueMap)headers, HttpMethod.POST, URI.create(url));
    }
}

