/*
 * Decompiled with CFR 0.152.
 */
package access.api;

import access.config.Config;
import access.manage.EntityType;
import access.manage.Manage;
import access.model.Application;
import access.model.Authority;
import access.model.User;
import access.repository.ApplicationRepository;
import access.repository.RoleRepository;
import access.security.UserPermissions;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.security.SecurityRequirements;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/manage", "/api/external/v1/manage"}, produces={"application/json"})
@Transactional
@SecurityRequirements(value={@SecurityRequirement(name="openId", scopes={"openid"}), @SecurityRequirement(name="apiTokens")})
@EnableConfigurationProperties(value={Config.class})
public class ManageController {
    private static final Log LOG = LogFactory.getLog(ManageController.class);
    private final Manage manage;
    private final RoleRepository roleRepository;
    private final ApplicationRepository applicationRepository;

    @Autowired
    public ManageController(Manage manage, RoleRepository roleRepository, ApplicationRepository applicationRepository) {
        this.manage = manage;
        this.roleRepository = roleRepository;
        this.applicationRepository = applicationRepository;
    }

    @GetMapping(value={"provider/{type}/{id}"})
    public ResponseEntity<Map<String, Object>> providerById(@PathVariable(value="type") EntityType type, @PathVariable(value="id") String id, @Parameter(hidden=true) User user) {
        LOG.debug((Object)"/provider");
        UserPermissions.assertSuperUser((User)user);
        Map provider = this.manage.providerById(type, id);
        return ResponseEntity.ok((Object)provider);
    }

    @GetMapping(value={"providers"})
    public ResponseEntity<List<Map<String, Object>>> providers(@Parameter(hidden=true) User user) {
        LOG.debug((Object)"/providers");
        UserPermissions.assertAuthority((User)user, (Authority)Authority.SUPER_USER);
        List providers = this.manage.providers(new EntityType[]{EntityType.SAML20_SP, EntityType.OIDC10_RP});
        return ResponseEntity.ok((Object)providers);
    }

    @GetMapping(value={"applications"})
    public ResponseEntity<Map<String, List<Map<String, Object>>>> applications(@Parameter(hidden=true) User user) {
        UserPermissions.assertInstitutionAdmin((User)user);
        List applications = user.isSuperUser() ? this.applicationRepository.findAll() : this.applicationRepository.findByManageIdIn(user.getApplications().stream().map(application -> (String)application.get("id")).collect(Collectors.toList()));
        Map<EntityType, List<Application>> groupedByManageType = applications.stream().collect(Collectors.groupingBy(Application::getManageType));
        List providers = groupedByManageType.entrySet().stream().map(entry -> this.manage.providersByIdIn((EntityType)entry.getKey(), ((List)entry.getValue()).stream().map(Application::getManageId).collect(Collectors.toList()))).flatMap(Collection::stream).toList();
        List provisionings = this.manage.provisioning(applications.stream().map(Application::getManageId).toList());
        return ResponseEntity.ok(Map.of("providers", providers, "provisionings", provisionings));
    }
}

