/*
 * Decompiled with CFR 0.152.
 */
package access.manage;

import access.manage.EntityType;
import access.manage.Manage;
import access.manage.ResilientErrorHandler;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.core.io.ClassPathResource;
import org.springframework.http.client.support.BasicAuthenticationInterceptor;
import org.springframework.util.CollectionUtils;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;

public class RemoteManage
implements Manage {
    private final String url;
    private final RestTemplate restTemplate = new RestTemplate();
    private final Map<String, Object> queries;

    public RemoteManage(String url, String user, String password, ObjectMapper objectMapper) throws IOException {
        this.url = url;
        this.queries = (Map)objectMapper.readValue(new ClassPathResource("/manage/query_templates.json").getInputStream(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        this.restTemplate.getInterceptors().add(new BasicAuthenticationInterceptor(user, password));
        ResilientErrorHandler resilientErrorHandler = new ResilientErrorHandler();
        this.restTemplate.setErrorHandler((ResponseErrorHandler)resilientErrorHandler);
    }

    public List<Map<String, Object>> providers(EntityType ... entityTypes) {
        return Stream.of(entityTypes).map(entityType -> this.getRemoteMetaData(entityType.collectionName())).flatMap(Collection::stream).toList();
    }

    public List<Map<String, Object>> providersByIdIn(EntityType entityType, List<String> identifiers) {
        if (CollectionUtils.isEmpty(identifiers)) {
            return Collections.emptyList();
        }
        String param = identifiers.stream().map(id -> String.format("\"%s\"", id)).collect(Collectors.joining(","));
        String query = URLEncoder.encode(String.format("{ \"id\": { $in: [%s]}}", param), Charset.defaultCharset());
        String queryUrl = String.format("%s/manage/api/internal/rawSearch/%s?query=%s", this.url, entityType.collectionName(), query);
        return this.transformProvider((List)this.restTemplate.getForEntity(queryUrl, List.class, new Object[0]).getBody());
    }

    public Optional<Map<String, Object>> providerByEntityID(EntityType entityType, String entityID) {
        String query = URLEncoder.encode(String.format("{\"data.entityid\":\"%s\"}", entityID), Charset.defaultCharset());
        String queryUrl = String.format("%s/manage/api/internal/rawSearch/%s?query=%s", this.url, entityType.collectionName(), query);
        List providers = this.transformProvider((List)this.restTemplate.getForEntity(queryUrl, List.class, new Object[0]).getBody());
        return providers.isEmpty() ? Optional.empty() : Optional.of((Map)providers.get(0));
    }

    public Map<String, Object> providerById(EntityType entityType, String id) {
        String queryUrl = String.format("%s/manage/api/internal/metadata/%s/%s", this.url, entityType.collectionName(), id);
        return this.transformProvider((Map)this.restTemplate.getForEntity(queryUrl, Map.class, new Object[0]).getBody());
    }

    public List<Map<String, Object>> provisioning(Collection<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.emptyList();
        }
        String queryUrl = String.format("%s/manage/api/internal/provisioning", this.url);
        return this.transformProvider((List)this.restTemplate.postForObject(queryUrl, ids, List.class, new Object[0]));
    }

    public List<Map<String, Object>> providersAllowedByIdP(Map<String, Object> identityProvider) {
        Boolean allowedAll = (Boolean)identityProvider.getOrDefault("allowedall", Boolean.FALSE);
        if (allowedAll.booleanValue()) {
            return this.providers(new EntityType[]{EntityType.SAML20_SP, EntityType.OIDC10_RP});
        }
        List allowedEntities = identityProvider.getOrDefault("allowedEntities", Collections.emptyList());
        String split = allowedEntities.stream().map(m -> "\"" + (String)m.get("name") + "\"").collect(Collectors.joining(","));
        String queryPart = URLEncoder.encode(String.format("{\"data.entityid\":{\"$in\":[%s]}}", split), Charset.defaultCharset());
        ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
        List.of(EntityType.SAML20_SP, EntityType.OIDC10_RP).forEach(entityType -> {
            String queryUrl = String.format("%s/manage/api/internal/rawSearch/%s?query=%s", this.url, entityType.collectionName(), queryPart);
            List providers = this.transformProvider((List)this.restTemplate.getForEntity(queryUrl, List.class, new Object[0]).getBody());
            results.addAll(providers);
        });
        return results;
    }

    public Optional<Map<String, Object>> identityProviderByInstitutionalGUID(String organisationGUID) {
        Map baseQuery = this.getBaseQuery();
        baseQuery.put("metaDataFields.coin:institution_guid", organisationGUID);
        List requestedAttributes = (List)baseQuery.get("REQUESTED_ATTRIBUTES");
        requestedAttributes.add("allowedEntities");
        requestedAttributes.add("allowedall");
        List identityProviders = (List)this.restTemplate.postForObject(String.format("%s/manage/api/internal/search/%s", this.url, EntityType.SAML20_IDP.collectionName()), (Object)baseQuery, List.class, new Object[0]);
        return identityProviders.isEmpty() ? Optional.empty() : Optional.of(this.transformProvider((Map)identityProviders.get(0)));
    }

    private List<Map<String, Object>> getRemoteMetaData(String type) {
        Map baseQuery = this.getBaseQuery();
        String url = String.format("%s/manage/api/internal/search/%s", this.url, type);
        return this.transformProvider((List)this.restTemplate.postForObject(url, (Object)baseQuery, List.class, new Object[0]));
    }

    private Map<String, Object> getBaseQuery() {
        HashMap<String, Object> baseQuery = new HashMap<String, Object>((Map)this.queries.get("base_query"));
        baseQuery.put("REQUESTED_ATTRIBUTES", baseQuery.get("REQUESTED_ATTRIBUTES"));
        return baseQuery;
    }
}

