/*
 * Decompiled with CFR 0.152.
 */
package access.profile;

import access.manage.Manage;
import access.model.Authority;
import access.model.Role;
import access.model.User;
import access.model.UserRole;
import access.profile.ApplicationInfo;
import access.profile.UserRoleProfile;
import access.repository.UserRepository;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/profile", "/api/external/v1/profile"}, produces={"application/json"})
@SecurityRequirement(name="basic_auth")
public class ProfileController {
    private static final Log LOG = LogFactory.getLog(ProfileController.class);
    private final UserRepository userRepository;
    private final Manage manage;

    public ProfileController(UserRepository userRepository, Manage manage) {
        this.userRepository = userRepository;
        this.manage = manage;
    }

    @GetMapping(value={""})
    @PreAuthorize(value="hasRole('PROFILE')")
    public ResponseEntity<List<UserRoleProfile>> roles(@RequestParam(value="collabPersonId") String collabPersonId) {
        LOG.debug((Object)("Fetch profile roles for:" + collabPersonId));
        Optional optionalUser = this.userRepository.findBySubIgnoreCase(collabPersonId);
        Set userRoles = optionalUser.map(User::getUserRoles).orElse(Collections.emptySet());
        List<Role> roles = userRoles.stream().filter(userRole -> userRole.getAuthority().equals((Object)Authority.GUEST) || userRole.isGuestRoleIncluded()).map(UserRole::getRole).toList();
        return ResponseEntity.ok(this.manage.addManageMetaData(roles).stream().map(arg_0 -> this.userRoleProfile(arg_0)).toList());
    }

    private UserRoleProfile userRoleProfile(Role role) {
        return new UserRoleProfile(role.getName(), role.getDescription(), this.applicationInfoList(role));
    }

    private List<ApplicationInfo> applicationInfoList(Role role) {
        return role.getApplicationMaps().stream().map(applicationMap -> new ApplicationInfo((String)applicationMap.get("landingPage"), (String)applicationMap.get("name:en"), (String)applicationMap.get("name:nl"), (String)applicationMap.get("OrganizationName:en"), (String)applicationMap.get("OrganizationName:nl"), (String)applicationMap.get("logo"))).toList();
    }
}

