/*
 * Decompiled with CFR 0.152.
 */
package access.model;

import access.manage.ManageIdentifier;
import access.model.Authority;
import access.model.Provisionable;
import access.model.Role;
import access.model.UserRole;
import access.model.UserRoleProvisioning;
import com.fasterxml.jackson.annotation.JsonIgnore;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Transient;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.springframework.util.StringUtils;

@Entity(name="users")
public class User
implements Serializable,
Provisionable {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column
    @NotNull
    private String sub;
    @Column(name="super_user")
    @NotNull
    private boolean superUser;
    @Column(name="eduperson_principal_name")
    private String eduPersonPrincipalName;
    @Column(name="given_name")
    private String givenName;
    @Column(name="family_name")
    private String familyName;
    @Column(name="name")
    private String name;
    @Column(name="subject_id")
    private String subjectId;
    @Column(name="eduid")
    private String eduId;
    @Column(name="uid")
    private String uid;
    @Column(name="schac_home_organization")
    private String schacHomeOrganization;
    @Column(name="organization_guid")
    private String organizationGUID;
    @Column(name="institution_admin")
    @NotNull
    private boolean institutionAdmin;
    @Column(name="institution_admin_by_invite")
    @NotNull
    private boolean institutionAdminByInvite;
    @Column
    private String email;
    @Column(name="created_at")
    private Instant createdAt;
    @Column(name="last_activity")
    private Instant lastActivity;
    @OneToMany(mappedBy="user", orphanRemoval=true, fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    private Set<UserRole> userRoles = new HashSet();
    @Transient
    private List<Map<String, Object>> applications = Collections.emptyList();
    @Transient
    private Map<String, Object> institution = Collections.emptyMap();

    public User(Map<String, Object> attributes) {
        this(false, attributes);
    }

    public User(boolean superUser, Map<String, Object> attributes) {
        this.superUser = superUser;
        this.sub = (String)attributes.get("sub");
        this.eduPersonPrincipalName = (String)attributes.get("eduperson_principal_name");
        this.schacHomeOrganization = (String)attributes.get("schac_home_organization");
        this.email = (String)attributes.get("email");
        this.givenName = (String)attributes.get("given_name");
        this.familyName = (String)attributes.get("family_name");
        this.subjectId = (String)attributes.get("subject_id");
        this.eduId = (String)attributes.get("eduid");
        this.uid = attributes.getOrDefault("uids", List.of()).stream().findAny().orElse(null);
        this.institutionAdmin = (Boolean)attributes.getOrDefault("INSTITUTION_ADMIN", false);
        this.organizationGUID = (String)attributes.get("ORGANIZATION_GUID");
        this.applications = attributes.getOrDefault("APPLICATIONS", Collections.emptyList());
        this.institution = attributes.getOrDefault("INSTITUTION", Collections.emptyMap());
        this.lastActivity = this.createdAt = Instant.now();
        if (!StringUtils.hasText((String)this.eduPersonPrincipalName)) {
            this.eduPersonPrincipalName = this.email;
        }
        this.nameInvariant(attributes);
    }

    public User(UserRoleProvisioning userRoleProvisioning) {
        userRoleProvisioning.validate();
        this.sub = userRoleProvisioning.resolveSub();
        this.email = userRoleProvisioning.email;
        this.eduPersonPrincipalName = StringUtils.hasText((String)userRoleProvisioning.eduPersonPrincipalName) ? userRoleProvisioning.eduPersonPrincipalName : this.email;
        this.schacHomeOrganization = StringUtils.hasText((String)userRoleProvisioning.schacHomeOrganization) ? userRoleProvisioning.schacHomeOrganization : this.schacHomeOrganization;
        this.name = userRoleProvisioning.name;
        this.givenName = userRoleProvisioning.givenName;
        this.familyName = userRoleProvisioning.familyName;
        this.lastActivity = this.createdAt = Instant.now();
        this.nameInvariant(Map.of("name", StringUtils.hasText((String)this.name) ? this.name : "", "preferred_username", ""));
    }

    private void nameInvariant(Map<String, Object> attributes) {
        String name = (String)attributes.get("name");
        String preferredUsername = (String)attributes.get("preferred_username");
        if (StringUtils.hasText((String)name)) {
            this.name = name;
        } else if (StringUtils.hasText((String)preferredUsername)) {
            this.name = preferredUsername;
        } else if (StringUtils.hasText((String)this.givenName) && StringUtils.hasText((String)this.familyName)) {
            this.name = this.givenName + " " + this.familyName;
        } else if (StringUtils.hasText((String)this.email) && this.email.contains("@")) {
            this.name = Stream.of(this.email.substring(0, this.email.indexOf("@")).toLowerCase().split("\\.")).map(StringUtils::capitalize).collect(Collectors.joining(" "));
        } else if (StringUtils.hasText((String)this.sub)) {
            this.name = StringUtils.capitalize((String)this.sub.substring(this.sub.lastIndexOf(":") + 1));
        }
        this.nameInvariant();
    }

    public void nameInvariant() {
        if (!StringUtils.hasText((String)this.givenName) && !StringUtils.hasText((String)this.familyName) && StringUtils.hasText((String)this.name) && this.name.contains(" ")) {
            List<String> names = Arrays.asList(this.name.split(" "));
            this.givenName = names.get(0);
            this.familyName = String.join((CharSequence)" ", names.stream().skip(1L).toList());
        }
    }

    public User(boolean superUser, String eppn, String sub, String schacHomeOrganization, String givenName, String familyName, String email) {
        this.superUser = superUser;
        this.eduPersonPrincipalName = eppn;
        this.sub = sub;
        this.schacHomeOrganization = schacHomeOrganization;
        this.givenName = givenName;
        this.familyName = familyName;
        this.name = String.format("%s %s", givenName, familyName);
        this.email = email;
        this.createdAt = Instant.now();
        this.lastActivity = Instant.now();
    }

    @JsonIgnore
    public UserRole addUserRole(UserRole userRole) {
        this.userRoles.add(userRole);
        userRole.setUser(this);
        return userRole;
    }

    @JsonIgnore
    public void removeUserRole(UserRole role) {
        Set newRoles = this.userRoles.stream().filter(ur -> !ur.getId().equals(role.getId())).collect(Collectors.toSet());
        this.userRoles.clear();
        this.userRoles.addAll(newRoles);
    }

    @JsonIgnore
    public Set<ManageIdentifier> manageIdentifierSet() {
        return this.userRoles.stream().filter(userRole -> userRole.getAuthority().equals((Object)Authority.GUEST) || userRole.isGuestRoleIncluded()).map(userRole -> userRole.getRole().getApplicationUsages()).flatMap(Collection::stream).map(applicationUsage -> new ManageIdentifier(applicationUsage.getApplication().getManageId(), applicationUsage.getApplication().getManageType())).collect(Collectors.toSet());
    }

    @JsonIgnore
    public Map<String, Object> asMap() {
        if (!StringUtils.hasText((String)this.sub)) {
            throw new IllegalArgumentException("Sub is empty for User: " + this.getId());
        }
        String notNullIdentifier = StringUtils.hasText((String)this.email) ? this.email : (StringUtils.hasText((String)this.eduPersonPrincipalName) ? this.eduPersonPrincipalName : this.sub);
        Instant epochStart = Instant.ofEpochMilli(0L);
        return Map.of("id", Objects.isNull(this.id) ? 0L : this.id, "name", StringUtils.hasText((String)this.name) ? this.name : notNullIdentifier, "email", notNullIdentifier, "createdAt", this.createdAt != null ? this.createdAt : epochStart, "lastActivity", this.lastActivity != null ? this.lastActivity : epochStart, "schacHomeOrganization", StringUtils.hasText((String)this.schacHomeOrganization) ? this.schacHomeOrganization : "Unknown schac", "sub", this.sub);
    }

    @JsonIgnore
    public boolean updateAttributes(Map<String, Object> attributes) {
        boolean changed = false;
        String newEdupersonPrincipalName = (String)attributes.get("eduperson_principal_name");
        changed = changed || !Objects.equals(this.eduPersonPrincipalName, newEdupersonPrincipalName);
        this.eduPersonPrincipalName = newEdupersonPrincipalName;
        String newSchacHomeOrganization = (String)attributes.get("schac_home_organization");
        changed = changed || !Objects.equals(this.schacHomeOrganization, newSchacHomeOrganization);
        this.schacHomeOrganization = newSchacHomeOrganization;
        String newGivenName = (String)attributes.get("given_name");
        changed = changed || !Objects.equals(this.givenName, newGivenName);
        this.givenName = newGivenName;
        String newFamilyName = (String)attributes.get("family_name");
        changed = changed || !Objects.equals(this.familyName, newFamilyName);
        this.familyName = newFamilyName;
        String newEmail = (String)attributes.get("email");
        changed = changed || !Objects.equals(this.email, newEmail);
        this.email = newEmail;
        this.lastActivity = Instant.now();
        String currentName = this.name;
        String currentGivenName = this.givenName;
        String currentFamilyName = this.familyName;
        this.nameInvariant(attributes);
        changed = changed || !Objects.equals(this.name, currentName) || !Objects.equals(this.givenName, currentGivenName) || !Objects.equals(this.familyName, currentFamilyName);
        this.updateRemoteAttributes(attributes);
        return changed;
    }

    @JsonIgnore
    public void updateRemoteAttributes(Map<String, Object> attributes) {
        this.institutionAdmin = (Boolean)attributes.getOrDefault("INSTITUTION_ADMIN", false);
        this.organizationGUID = (String)attributes.get("ORGANIZATION_GUID");
        this.applications = attributes.getOrDefault("APPLICATIONS", Collections.emptyList());
        this.institution = attributes.getOrDefault("INSTITUTION", Collections.emptyMap());
    }

    @JsonIgnore
    public Optional<UserRole> latestUserRole() {
        return this.userRoles.stream().max(Comparator.comparing(UserRole::getCreatedAt));
    }

    @JsonIgnore
    public Optional<UserRole> userRoleForRole(Role role) {
        return this.userRoles.stream().filter(userRole -> userRole.getRole().getId().equals(role.getId())).findFirst();
    }

    @Generated
    public User() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getSub() {
        return this.sub;
    }

    @Generated
    public boolean isSuperUser() {
        return this.superUser;
    }

    @Generated
    public String getEduPersonPrincipalName() {
        return this.eduPersonPrincipalName;
    }

    @Generated
    public String getGivenName() {
        return this.givenName;
    }

    @Generated
    public String getFamilyName() {
        return this.familyName;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getSubjectId() {
        return this.subjectId;
    }

    @Generated
    public String getEduId() {
        return this.eduId;
    }

    @Generated
    public String getUid() {
        return this.uid;
    }

    @Generated
    public String getSchacHomeOrganization() {
        return this.schacHomeOrganization;
    }

    @Generated
    public String getOrganizationGUID() {
        return this.organizationGUID;
    }

    @Generated
    public boolean isInstitutionAdmin() {
        return this.institutionAdmin;
    }

    @Generated
    public boolean isInstitutionAdminByInvite() {
        return this.institutionAdminByInvite;
    }

    @Generated
    public String getEmail() {
        return this.email;
    }

    @Generated
    public Instant getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public Instant getLastActivity() {
        return this.lastActivity;
    }

    @Generated
    public Set<UserRole> getUserRoles() {
        return this.userRoles;
    }

    @Generated
    public List<Map<String, Object>> getApplications() {
        return this.applications;
    }

    @Generated
    public Map<String, Object> getInstitution() {
        return this.institution;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setSub(String sub) {
        this.sub = sub;
    }

    @Generated
    public void setSuperUser(boolean superUser) {
        this.superUser = superUser;
    }

    @Generated
    public void setEduPersonPrincipalName(String eduPersonPrincipalName) {
        this.eduPersonPrincipalName = eduPersonPrincipalName;
    }

    @Generated
    public void setGivenName(String givenName) {
        this.givenName = givenName;
    }

    @Generated
    public void setFamilyName(String familyName) {
        this.familyName = familyName;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setSubjectId(String subjectId) {
        this.subjectId = subjectId;
    }

    @Generated
    public void setEduId(String eduId) {
        this.eduId = eduId;
    }

    @Generated
    public void setUid(String uid) {
        this.uid = uid;
    }

    @Generated
    public void setSchacHomeOrganization(String schacHomeOrganization) {
        this.schacHomeOrganization = schacHomeOrganization;
    }

    @Generated
    public void setOrganizationGUID(String organizationGUID) {
        this.organizationGUID = organizationGUID;
    }

    @Generated
    public void setInstitutionAdmin(boolean institutionAdmin) {
        this.institutionAdmin = institutionAdmin;
    }

    @Generated
    public void setInstitutionAdminByInvite(boolean institutionAdminByInvite) {
        this.institutionAdminByInvite = institutionAdminByInvite;
    }

    @Generated
    public void setEmail(String email) {
        this.email = email;
    }

    @Generated
    public void setCreatedAt(Instant createdAt) {
        this.createdAt = createdAt;
    }

    @Generated
    public void setLastActivity(Instant lastActivity) {
        this.lastActivity = lastActivity;
    }

    @Generated
    public void setUserRoles(Set<UserRole> userRoles) {
        this.userRoles = userRoles;
    }

    @Generated
    public void setApplications(List<Map<String, Object>> applications) {
        this.applications = applications;
    }

    @Generated
    public void setInstitution(Map<String, Object> institution) {
        this.institution = institution;
    }
}

