/*
 * Decompiled with CFR 0.152.
 */
package access.security;

import access.model.Provisionable;
import access.security.Scope;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.security.core.CredentialsContainer;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

public class RemoteUser
implements UserDetails,
CredentialsContainer,
Provisionable {
    private String username;
    private String password;
    private List<Scope> scopes;

    public RemoteUser(RemoteUser remoteUser) {
        this.username = remoteUser.username;
        this.password = remoteUser.password;
        this.scopes = remoteUser.scopes;
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        return this.scopes.stream().map(scope -> new SimpleGrantedAuthority("ROLE_" + scope.name().toUpperCase())).collect(Collectors.toList());
    }

    public String getName() {
        return this.username;
    }

    public void eraseCredentials() {
        this.password = null;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public List<Scope> getScopes() {
        return this.scopes;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public void setPassword(String password) {
        this.password = password;
    }

    @Generated
    public void setScopes(List<Scope> scopes) {
        this.scopes = scopes;
    }

    @Generated
    public RemoteUser() {
    }
}

