/*
 * Decompiled with CFR 0.152.
 */
package access.api;

import access.api.ApplicationResource;
import access.api.Results;
import access.api.RoleOperations;
import access.config.Config;
import access.exception.NotFoundException;
import access.exception.UserRestrictionException;
import access.logging.AccessLogger;
import access.logging.Event;
import access.manage.Manage;
import access.model.Application;
import access.model.Authority;
import access.model.Provisionable;
import access.model.Role;
import access.model.User;
import access.model.UserRole;
import access.provision.ProvisioningService;
import access.provision.scim.GroupURN;
import access.repository.ApplicationRepository;
import access.repository.ApplicationUsageRepository;
import access.repository.RoleRepository;
import access.security.UserPermissions;
import access.validation.URLFormatValidator;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.security.SecurityRequirements;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/roles", "/api/external/v1/roles"}, produces={"application/json"})
@Transactional
@SecurityRequirements(value={@SecurityRequirement(name="openId", scopes={"openid"}), @SecurityRequirement(name="apiTokens")})
@EnableConfigurationProperties(value={Config.class})
public class RoleController
implements ApplicationResource {
    private static final Log LOG = LogFactory.getLog(RoleController.class);
    private final Config config;
    private final RoleRepository roleRepository;
    private final ApplicationRepository applicationRepository;
    private final ApplicationUsageRepository applicationUsageRepository;
    private final Manage manage;
    private final ProvisioningService provisioningService;
    private final URLFormatValidator urlFormatValidator = new URLFormatValidator();
    private final boolean limitInstitutionAdminRoleVisibility;
    private final RoleOperations roleOperations;

    public RoleController(Config config, RoleRepository roleRepository, ApplicationRepository applicationRepository, ApplicationUsageRepository applicationUsageRepository, Manage manage, ProvisioningService provisioningService, @Value(value="${feature.limit-institution-admin-role-visibility}") boolean limitInstitutionAdminRoleVisibility) {
        this.config = config;
        this.roleRepository = roleRepository;
        this.applicationRepository = applicationRepository;
        this.applicationUsageRepository = applicationUsageRepository;
        this.manage = manage;
        this.provisioningService = provisioningService;
        this.limitInstitutionAdminRoleVisibility = limitInstitutionAdminRoleVisibility;
        this.roleOperations = new RoleOperations((ApplicationResource)this);
    }

    @GetMapping(value={""})
    public ResponseEntity<List<Role>> rolesByApplication(@Parameter(hidden=true) User user) {
        LOG.debug((Object)String.format("/roles for user %s", user.getEduPersonPrincipalName()));
        if (user.isSuperUser()) {
            return ResponseEntity.ok((Object)this.manage.addManageMetaData(this.roleRepository.findAll()));
        }
        UserPermissions.assertAuthority((User)user, (Authority)Authority.INSTITUTION_ADMIN);
        if (this.limitInstitutionAdminRoleVisibility) {
            List roles = this.roleRepository.findByOrganizationGUID(user.getOrganizationGUID());
            return ResponseEntity.ok((Object)this.manage.addManageMetaData(roles));
        }
        HashSet manageIdentifiers = new HashSet();
        if (user.isInstitutionAdmin()) {
            Set applicationManageIdentifiers = user.getApplications().stream().map(m -> (String)m.get("id")).collect(Collectors.toSet());
            manageIdentifiers.addAll(applicationManageIdentifiers);
        }
        Set roleManageIdentifiers = user.getUserRoles().stream().filter(userRole -> userRole.getAuthority().hasEqualOrHigherRights(Authority.MANAGER)).map(userRole -> userRole.getRole().applicationsUsed()).flatMap(Collection::stream).map(Application::getManageId).collect(Collectors.toSet());
        manageIdentifiers.addAll(roleManageIdentifiers);
        ArrayList roles = new ArrayList();
        manageIdentifiers.forEach(manageId -> roles.addAll(this.roleRepository.findByApplicationUsagesApplicationManageId(manageId)));
        return ResponseEntity.ok((Object)this.manage.addManageMetaData(roles));
    }

    @GetMapping(value={"{id}"})
    public ResponseEntity<Role> role(@PathVariable(value="id") Long id, @Parameter(hidden=true) User user) {
        LOG.debug((Object)String.format("/role/%s for user %s", id, user.getEduPersonPrincipalName()));
        Role role = (Role)this.roleRepository.findById((Object)id).orElseThrow(() -> new NotFoundException("Role not found"));
        UserPermissions.assertRoleAccess((User)user, (Role)role, (Authority)Authority.INVITER);
        this.manage.addManageMetaData(List.of(role));
        return ResponseEntity.ok((Object)role);
    }

    @GetMapping(value={"/application/{manageId}"})
    public ResponseEntity<List<Role>> rolesPerApplicationId(@PathVariable(value="manageId") String manageId, @Parameter(hidden=true) User user) {
        LOG.debug((Object)String.format("/rolesPerApplicationId for user %s", user.getEduPersonPrincipalName()));
        UserPermissions.assertAuthority((User)user, (Authority)Authority.INSTITUTION_ADMIN);
        if (!user.isSuperUser()) {
            Set applicationManageIdentifiers = user.getApplications().stream().map(m -> (String)m.get("id")).collect(Collectors.toSet());
            Set roleManageIdentifiers = user.getUserRoles().stream().filter(userRole -> userRole.getAuthority().hasEqualOrHigherRights(Authority.MANAGER)).map(userRole -> userRole.getRole().applicationsUsed()).flatMap(Collection::stream).map(Application::getManageId).collect(Collectors.toSet());
            applicationManageIdentifiers.addAll(roleManageIdentifiers);
            if (!applicationManageIdentifiers.contains(manageId)) {
                throw new UserRestrictionException();
            }
        }
        List roles = this.roleRepository.findByApplicationUsagesApplicationManageId(manageId);
        return ResponseEntity.ok((Object)this.manage.addManageMetaData(roles));
    }

    @GetMapping(value={"search"})
    public ResponseEntity<List<Role>> search(@RequestParam(value="query") String query, @Parameter(hidden=true) User user) {
        LOG.debug((Object)"/search");
        UserPermissions.assertSuperUser((User)user);
        List roles = this.roleRepository.search(query + "*", 15);
        return ResponseEntity.ok((Object)this.manage.addManageMetaData(roles));
    }

    @PostMapping(value={""})
    public ResponseEntity<Role> newRole(@Validated @RequestBody Role role, @Parameter(hidden=true) User user) {
        UserPermissions.assertAuthority((User)user, (Authority)Authority.INSTITUTION_ADMIN);
        role.setOrganizationGUID(user.getOrganizationGUID());
        role.setShortName(GroupURN.sanitizeRoleShortName((String)role.getShortName()));
        role.setIdentifier(UUID.randomUUID().toString());
        LOG.debug((Object)String.format("New role '%s' by user %s", role.getName(), user.getName()));
        return this.saveOrUpdate(role, user);
    }

    @PutMapping(value={""})
    public ResponseEntity<Role> updateRole(@Validated @RequestBody Role role, @Parameter(hidden=true) User user) {
        UserPermissions.assertAuthority((User)user, (Authority)Authority.MANAGER);
        LOG.debug((Object)String.format("Update role '%s' by user %s", role.getName(), user.getEduPersonPrincipalName()));
        return this.saveOrUpdate(role, user);
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> deleteRole(@PathVariable(value="id") Long id, @Parameter(hidden=true) User user) {
        Role role = (Role)this.roleRepository.findById((Object)id).orElseThrow(() -> new NotFoundException("Role not found"));
        LOG.debug((Object)String.format("Delete role %s by user %s", role.getName(), user.getEduPersonPrincipalName()));
        this.manage.addManageMetaData(List.of(role));
        UserPermissions.assertAuthority((User)user, (Authority)Authority.INSTITUTION_ADMIN);
        if (this.limitInstitutionAdminRoleVisibility && !user.getOrganizationGUID().equals(role.getOrganizationGUID())) {
            throw new UserRestrictionException();
        }
        this.provisioningService.deleteGroupRequest(role);
        this.roleRepository.delete((Object)role);
        AccessLogger.role((Log)LOG, (Event)Event.Deleted, (Provisionable)user, (Role)role);
        return Results.deleteResult();
    }

    private ResponseEntity<Role> saveOrUpdate(Role role, User user) {
        this.roleOperations.assertValidRole(role);
        this.manage.addManageMetaData(List.of(role));
        boolean isNew = role.getId() == null;
        ArrayList previousApplicationIdentifiers = new ArrayList();
        Optional optionalUserRole = user.userRoleForRole(role);
        boolean immutableApplicationUsages = optionalUserRole.isPresent() && ((UserRole)optionalUserRole.get()).getAuthority().equals((Object)Authority.MANAGER);
        boolean nameChanged = false;
        if (!isNew) {
            Role previousRole = (Role)this.roleRepository.findById((Object)role.getId()).orElseThrow(() -> new NotFoundException("Role not found"));
            role.setShortName(previousRole.getShortName());
            role.setIdentifier(previousRole.getIdentifier());
            if (user.isSuperUser()) {
                role.setOrganizationGUID(role.getOrganizationGUID());
            } else {
                role.setOrganizationGUID(previousRole.getOrganizationGUID());
            }
            previousApplicationIdentifiers.addAll(previousRole.applicationIdentifiers());
            if (immutableApplicationUsages) {
                role.setApplicationUsages(previousRole.getApplicationUsages());
            }
            boolean bl = nameChanged = !previousRole.getName().equals(role.getName());
        }
        if (!immutableApplicationUsages) {
            this.roleOperations.syncRoleApplicationUsages(role);
        }
        Role saved = (Role)this.roleRepository.save((Object)role);
        if (isNew) {
            this.provisioningService.newGroupRequest(saved);
        } else {
            this.provisioningService.updateGroupRequest(previousApplicationIdentifiers, saved, nameChanged);
        }
        AccessLogger.role((Log)LOG, (Event)(isNew ? Event.Created : Event.Updated), (Provisionable)user, (Role)role);
        return ResponseEntity.ok((Object)saved);
    }

    @Generated
    public ApplicationRepository getApplicationRepository() {
        return this.applicationRepository;
    }

    @Generated
    public ApplicationUsageRepository getApplicationUsageRepository() {
        return this.applicationUsageRepository;
    }
}

