/*
 * Decompiled with CFR 0.152.
 */
package access.repository;

import access.model.Role;
import access.model.UserRole;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

@Repository
public interface UserRoleRepository
extends JpaRepository<UserRole, Long> {
    public List<UserRole> findByEndDateBefore(Instant var1);

    public List<UserRole> findByEndDateBeforeAndExpiryNotifications(Instant var1, Integer var2);

    public List<UserRole> findByRole(Role var1);

    public List<UserRole> findByRoleName(String var1);

    @Modifying
    @Query(value="DELETE FROM user_roles WHERE id = ?1", nativeQuery=true)
    @Transactional(isolation=Isolation.SERIALIZABLE)
    public void deleteUserRoleById(Long var1);

    @Modifying
    @Query(value="UPDATE user_roles SET expiry_notifications= ?1 WHERE id = ?2", nativeQuery=true)
    @Transactional(isolation=Isolation.SERIALIZABLE)
    public void updateExpiryNotifications(Integer var1, Long var2);

    @Query(value="        SELECT ur.authority, ur.end_date, ur.created_at, u.name, u.email, u.schac_home_organization\n        FROM user_roles ur INNER JOIN users u on u.id = ur.user_id\n        WHERE ur.role_id = ?1 AND (ur.authority = 'GUEST' OR ur.guest_role_included )\n", countQuery="SELECT COUNT(ur.id) FROM user_roles ur INNER JOIN users u on u.id = ur.user_id\nWHERE ur.role_id = ?1 AND (ur.authority = 'GUEST' OR ur.guest_role_included )\n", nativeQuery=true)
    public Page<Map<String, Object>> searchGuestsByPage(Long var1, Pageable var2);

    @Query(value="SELECT ur.authority, ur.end_date, ur.created_at, u.name, u.email, u.schac_home_organization\nFROM user_roles ur INNER JOIN users u on u.id = ur.user_id\nWHERE ur.role_id = ?1 AND (ur.authority = 'GUEST' OR ur.guest_role_included )\n          AND MATCH (u.given_name, u.family_name, u.email) AGAINST (?2  IN BOOLEAN MODE)\n", countQuery="SELECT COUNT(ur.id) FROM user_roles ur INNER JOIN users u on u.id = ur.user_id\nWHERE ur.role_id = ?1  AND (ur.authority = 'GUEST' OR ur.guest_role_included )\nAND MATCH (u.given_name, u.family_name, u.email) AGAINST (?2  IN BOOLEAN MODE)\n", nativeQuery=true)
    public Page<Map<String, Object>> searchGuestsByPageWithKeyword(Long var1, String var2, Pageable var3);

    @Query(value="SELECT ur.authority, ur.end_date, ur.created_at, u.name, u.email, u.schac_home_organization\nFROM user_roles ur INNER JOIN users u on u.id = ur.user_id WHERE ur.role_id = ?1 AND ur.authority <> 'GUEST'\n", countQuery="SELECT COUNT(ur.id) FROM user_roles ur INNER JOIN users u on u.id = ur.user_id\nWHERE ur.role_id = ?1 AND ur.authority <> 'GUEST'\n", nativeQuery=true)
    public Page<Map<String, Object>> searchNonGuestsByPage(Long var1, Pageable var2);

    @Query(value="SELECT ur.authority, ur.end_date, ur.created_at, u.name, u.email, u.schac_home_organization\nFROM user_roles ur INNER JOIN users u on u.id = ur.user_id WHERE ur.role_id = ?1\nAND ur.authority <> 'GUEST' AND MATCH (u.given_name, u.family_name, u.email) AGAINST (?2  IN BOOLEAN MODE)\n", countQuery="SELECT COUNT(ur.id) FROM user_roles ur INNER JOIN users u on u.id = ur.user_id\nWHERE ur.role_id = ?1 AND ur.authority <> 'GUEST'\nAND MATCH (u.given_name, u.family_name, u.email) AGAINST (?2  IN BOOLEAN MODE)\n", nativeQuery=true)
    public Page<Map<String, Object>> searchNonGuestsByPageWithKeyword(Long var1, String var2, Pageable var3);
}

