/*
 * Decompiled with CFR 0.152.
 */
package access.api;

import access.api.Results;
import access.config.Config;
import access.exception.NotFoundException;
import access.exception.UserRestrictionException;
import access.manage.EntityType;
import access.manage.Manage;
import access.model.Invitation;
import access.model.Role;
import access.model.User;
import access.model.UserRole;
import access.model.UserRoles;
import access.provision.Provisioning;
import access.provision.graph.GraphClient;
import access.repository.InvitationRepository;
import access.repository.RemoteProvisionedUserRepository;
import access.repository.RoleRepository;
import access.repository.UserRepository;
import access.security.UserPermissions;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import crypto.KeyStore;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.security.SecurityRequirements;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@RestController
@RequestMapping(value={"/api/v1/users", "/api/external/v1/users"}, produces={"application/json"})
@Transactional
@SecurityRequirements(value={@SecurityRequirement(name="openId", scopes={"openid"}), @SecurityRequirement(name="apiTokens")})
@EnableConfigurationProperties(value={Config.class})
public class UserController {
    private static final Log LOG = LogFactory.getLog(UserController.class);
    private final Config config;
    private final UserRepository userRepository;
    private final InvitationRepository invitationRepository;
    private final Manage manage;
    private final ObjectMapper objectMapper;
    private final RemoteProvisionedUserRepository remoteProvisionedUserRepository;
    private final GraphClient graphClient;
    private final boolean limitInstitutionAdminRoleVisibility;
    private final RoleRepository roleRepository;

    @Autowired
    public UserController(Config config, UserRepository userRepository, InvitationRepository invitationRepository, Manage manage, ObjectMapper objectMapper, RemoteProvisionedUserRepository remoteProvisionedUserRepository, KeyStore keyStore, @Value(value="${config.eduid-idp-schac-home-organization}") String eduidIdpSchacHomeOrganization, @Value(value="${config.server-url}") String serverBaseURL, @Value(value="${voot.group_urn_domain}") String groupUrnPrefix, @Value(value="${feature.limit-institution-admin-role-visibility}") boolean limitInstitutionAdminRoleVisibility, RoleRepository roleRepository) {
        this.invitationRepository = invitationRepository;
        this.config = config.withGroupUrnPrefix(groupUrnPrefix);
        this.userRepository = userRepository;
        this.objectMapper = objectMapper;
        this.manage = manage;
        this.remoteProvisionedUserRepository = remoteProvisionedUserRepository;
        this.limitInstitutionAdminRoleVisibility = limitInstitutionAdminRoleVisibility;
        this.graphClient = new GraphClient(serverBaseURL, eduidIdpSchacHomeOrganization, keyStore, objectMapper);
        this.roleRepository = roleRepository;
    }

    @GetMapping(value={"config"})
    public ResponseEntity<Config> config(User user, @RequestParam(value="guest", required=false, defaultValue="false") boolean guest) {
        LOG.debug((Object)"/config");
        Config result = new Config(this.config);
        result.withAuthenticated(user != null && user.getId() != null).withName(user != null ? user.getName() : null);
        if (user != null && user.getId() == null) {
            this.verifyMissingAttributes(user, result, guest);
        }
        return ResponseEntity.ok((Object)result);
    }

    @GetMapping(value={"me"})
    public ResponseEntity<User> me(@Parameter(hidden=true) User user) {
        LOG.debug((Object)String.format("/me for user %s", user.getEduPersonPrincipalName()));
        List<Role> roles = user.getUserRoles().stream().map(UserRole::getRole).toList();
        this.manage.addManageMetaData(roles);
        return ResponseEntity.ok((Object)user);
    }

    @GetMapping(value={"other/{id}"})
    public ResponseEntity<User> details(@PathVariable(value="id") Long id, @Parameter(hidden=true) User user) {
        LOG.debug((Object)String.format("/other/%s for user $s", id, user.getEduPersonPrincipalName()));
        User other = (User)this.userRepository.findById((Object)id).orElseThrow(() -> new NotFoundException("User not found"));
        List<Role> roles = other.getUserRoles().stream().map(UserRole::getRole).toList();
        this.manage.addManageMetaData(roles);
        if (!user.isSuperUser()) {
            UserPermissions.assertInstitutionAdmin((User)user);
            List<String> manageIdentifiers = user.getApplications().stream().map(application -> (String)application.get("id")).toList();
            boolean allowedByManage = roles.stream().anyMatch(role -> role.getApplicationUsages().stream().anyMatch(applicationUsage -> manageIdentifiers.contains(applicationUsage.getApplication().getManageId())));
            if (!allowedByManage) {
                throw new UserRestrictionException();
            }
        }
        return ResponseEntity.ok((Object)other);
    }

    @GetMapping(value={"search"})
    public ResponseEntity<List<User>> search(@RequestParam(value="query") String query, @Parameter(hidden=true) User user) {
        LOG.debug((Object)String.format("/search for user %s", user.getEduPersonPrincipalName()));
        UserPermissions.assertSuperUser((User)user);
        List users = query.equals("owl") ? this.userRepository.findAll() : this.userRepository.search(query.replaceAll("@", " ") + "*", 15);
        return ResponseEntity.ok((Object)users);
    }

    @GetMapping(value={"search-paginated"})
    public ResponseEntity<Page<?>> searchPaginated(@RequestParam(value="query", required=false, defaultValue="") String query, @RequestParam(value="pageNumber", required=false, defaultValue="0") int pageNumber, @RequestParam(value="pageSize", required=false, defaultValue="10") int pageSize, @RequestParam(value="sort", required=false, defaultValue="id") String sort, @RequestParam(value="sortDirection", required=false, defaultValue="ASC") String sortDirection, @Parameter(hidden=true) User user) {
        LOG.debug((Object)String.format("/search-paginated for user %s", user.getEduPersonPrincipalName()));
        UserPermissions.assertSuperUser((User)user);
        if (query.equals("owl")) {
            List content = this.userRepository.findAll();
            PageRequest pageRequest = PageRequest.of((int)0, (int)content.size(), (Sort)Sort.by((String[])new String[]{Sort.Direction.ASC.name(), "id"}));
            return ResponseEntity.ok((Object)new PageImpl(content, (Pageable)pageRequest, (long)content.size()));
        }
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)pageSize, (Sort)Sort.by((Sort.Direction)Sort.Direction.fromString((String)sortDirection), (String[])new String[]{sort}));
        Page page = StringUtils.hasText((String)query) ? this.userRepository.searchByPage((Pageable)pageable) : this.userRepository.searchByPageWithKeyword(query.replaceAll("@", " ") + "*", (Pageable)pageable);
        return ResponseEntity.ok((Object)page);
    }

    @GetMapping(value={"search-by-application"})
    public ResponseEntity<List<UserRoles>> searchByApplication(@RequestParam(value="query") String query, @Parameter(hidden=true) User user) {
        LOG.debug((Object)String.format("/searchByApplication for user %s and query %s", user.getEduPersonPrincipalName(), query));
        UserPermissions.assertInstitutionAdmin((User)user);
        List<Object> manageIdentifiers = this.limitInstitutionAdminRoleVisibility ? this.roleRepository.findByOrganizationGUID(user.getOrganizationGUID()).stream().map(role -> role.getApplicationUsages()).flatMap(Collection::stream).map(applicationUsage -> applicationUsage.getApplication().getManageId()).toList() : user.getApplications().stream().map(application -> (String)application.get("id")).collect(Collectors.toList());
        List results = query.equals("owl") ? this.userRepository.searchByApplicationAllUsers(manageIdentifiers) : this.userRepository.searchByApplication(manageIdentifiers, query.replaceAll("@", " ") + "*", 15);
        Map<Long, List<Map>> groupedBy = results.stream().collect(Collectors.groupingBy(map -> (Long)map.get("id")));
        List<UserRoles> userRoles = groupedBy.values().stream().map(UserRoles::new).toList();
        return ResponseEntity.ok(userRoles);
    }

    @GetMapping(value={"login"})
    public View login(@RequestParam(value="app", required=false, defaultValue="client") String app) {
        LOG.debug((Object)"/login");
        return new RedirectView(app.equals("client") ? this.config.getClientUrl() : this.config.getWelcomeUrl(), false);
    }

    @GetMapping(value={"logout"})
    public ResponseEntity<Map<String, Integer>> logout(HttpServletRequest request) {
        LOG.debug((Object)"/logout");
        SecurityContextHolder.clearContext();
        HttpSession session = request.getSession(false);
        if (session != null) {
            session.invalidate();
        }
        return Results.okResult();
    }

    @GetMapping(value={"ms-accept-return/{manageId}/{userId}"})
    public View msAcceptReturn(@PathVariable(value="manageId") String manageId, @PathVariable(value="userId") Long userId) {
        User user = (User)this.userRepository.findById((Object)userId).orElseThrow(() -> new NotFoundException("User not found"));
        LOG.info((Object)String.format("Return from MS accept. User %s", user.getEduPersonPrincipalName()));
        Map provisioningMap = this.manage.providerById(EntityType.PROVISIONING, manageId);
        Provisioning provisioning = new Provisioning(provisioningMap);
        AtomicReference<String> redirectReference = new AtomicReference<String>(this.config.getWelcomeUrl());
        Optional remoteProvisionedUserOptional = this.remoteProvisionedUserRepository.findByManageProvisioningIdAndUser(manageId, user);
        remoteProvisionedUserOptional.ifPresent(remoteProvisionedUser -> {
            this.graphClient.updateUserRequest(user, provisioning, remoteProvisionedUser.getRemoteIdentifier());
            String invitationHash = this.invitationRepository.findTopBySubInviteeOrderByCreatedAtDesc(user.getSub()).map(Invitation::getHash).orElse("");
            String redirectUrl = String.format("%s/proceed?hash=%s&isRedirect=true", this.config.getWelcomeUrl(), invitationHash);
            redirectReference.set(redirectUrl);
        });
        return new RedirectView(redirectReference.get());
    }

    @PostMapping(value={"error"})
    public ResponseEntity<Map<String, Integer>> error(@RequestBody Map<String, Object> payload, @Parameter(hidden=true) User user) throws JsonProcessingException, UnknownHostException {
        payload.put("dateTime", new SimpleDateFormat("yyyy-MM-dd hh:mm:ss").format(new Date()));
        payload.put("machine", InetAddress.getLocalHost().getHostName());
        payload.put("user", user);
        String msg = this.objectMapper.writeValueAsString(payload);
        LOG.error((Object)msg, (Throwable)new IllegalArgumentException(msg));
        return Results.createResult();
    }

    private void verifyMissingAttributes(User user, Config result, boolean guest) {
        ArrayList<String> missingAttributes = new ArrayList<String>();
        if (!StringUtils.hasText((String)user.getSub())) {
            missingAttributes.add("sub");
        }
        if (!StringUtils.hasText((String)user.getEmail())) {
            missingAttributes.add("email");
        }
        if (!StringUtils.hasText((String)user.getSchacHomeOrganization())) {
            missingAttributes.add("schacHomeOrganization");
        }
        if (guest && !StringUtils.hasText((String)user.getFamilyName())) {
            missingAttributes.add("familyName");
        }
        if (guest && !StringUtils.hasText((String)user.getGivenName())) {
            missingAttributes.add("givenName");
        }
        if (!missingAttributes.isEmpty()) {
            result.withMissingAttributes(missingAttributes);
        }
    }
}

