/*
 * Decompiled with CFR 0.152.
 */
package access.provision;

import access.eduid.EduID;
import access.eduid.EduIDProvision;
import access.exception.RemoteException;
import access.manage.Manage;
import access.manage.ManageIdentifier;
import access.model.Application;
import access.model.Authority;
import access.model.Provisionable;
import access.model.RemoteProvisionedGroup;
import access.model.RemoteProvisionedUser;
import access.model.Role;
import access.model.User;
import access.model.UserRole;
import access.provision.DefaultProvisioningResponse;
import access.provision.Provisioning;
import access.provision.ProvisioningResponse;
import access.provision.ProvisioningService;
import access.provision.ProvisioningServiceDefault;
import access.provision.ProvisioningType;
import access.provision.ScimUserIdentifier;
import access.provision.eva.EvaClient;
import access.provision.graph.GraphClient;
import access.provision.graph.GraphResponse;
import access.provision.scim.GroupPatchRequest;
import access.provision.scim.GroupRequest;
import access.provision.scim.GroupURN;
import access.provision.scim.Member;
import access.provision.scim.Operation;
import access.provision.scim.OperationType;
import access.provision.scim.UserRequest;
import access.repository.RemoteProvisionedGroupRepository;
import access.repository.RemoteProvisionedUserRepository;
import access.repository.UserRoleRepository;
import com.fasterxml.jackson.databind.ObjectMapper;
import crypto.KeyStore;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import okhttp3.OkHttpClient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.OkHttp3ClientHttpRequestFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Service
public class ProvisioningServiceDefault
implements ProvisioningService {
    public static final String USER_API = "users";
    public static final String GROUP_API = "groups";
    private static final Log LOG = LogFactory.getLog(ProvisioningServiceDefault.class);
    private final ParameterizedTypeReference<Map<String, Object>> mapParameterizedTypeReference = new /* Unavailable Anonymous Inner Class!! */;
    private final ParameterizedTypeReference<String> stringParameterizedTypeReference = new /* Unavailable Anonymous Inner Class!! */;
    private final RestTemplate restTemplate = new RestTemplate();
    private final UserRoleRepository userRoleRepository;
    private final RemoteProvisionedUserRepository remoteProvisionedUserRepository;
    private final RemoteProvisionedGroupRepository remoteProvisionedGroupRepository;
    private final Manage manage;
    private final ObjectMapper objectMapper;
    private final String groupUrnPrefix;
    private final GraphClient graphClient;
    private final EvaClient evaClient;
    private final KeyStore keyStore;
    private final EduID eduID;

    @Autowired
    public ProvisioningServiceDefault(UserRoleRepository userRoleRepository, RemoteProvisionedUserRepository remoteProvisionedUserRepository, RemoteProvisionedGroupRepository remoteProvisionedGroupRepository, Manage manage, ObjectMapper objectMapper, KeyStore keyStore, EduID eduID, @Value(value="${voot.group_urn_domain}") String groupUrnPrefix, @Value(value="${config.eduid-idp-schac-home-organization}") String eduidIdpSchacHomeOrganization, @Value(value="${config.server-url}") String serverBaseURL) {
        this.userRoleRepository = userRoleRepository;
        this.remoteProvisionedUserRepository = remoteProvisionedUserRepository;
        this.remoteProvisionedGroupRepository = remoteProvisionedGroupRepository;
        this.manage = manage;
        this.objectMapper = objectMapper;
        this.keyStore = keyStore;
        this.groupUrnPrefix = groupUrnPrefix;
        this.eduID = eduID;
        this.graphClient = new GraphClient(serverBaseURL, eduidIdpSchacHomeOrganization, keyStore, objectMapper);
        this.evaClient = new EvaClient(keyStore, remoteProvisionedUserRepository);
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.connectTimeout(1L, TimeUnit.MINUTES);
        builder.retryOnConnectionFailure(true);
        this.restTemplate.setRequestFactory((ClientHttpRequestFactory)new OkHttp3ClientHttpRequestFactory(builder.build()));
    }

    public Optional<GraphResponse> newUserRequest(User user) {
        List provisionings = this.getProvisionings(user);
        AtomicReference graphResponseReference = new AtomicReference();
        provisionings.stream().filter(provisioning -> this.remoteProvisionedUserRepository.findByManageProvisioningIdAndUser(provisioning.getId(), user).isEmpty()).forEach(provisioning -> {
            UserRequest request = new UserRequest(user, provisioning);
            if (provisioning.getScimUserIdentifier().equals((Object)ScimUserIdentifier.eduID) && request.getExternalId().equals(user.getEduId())) {
                this.eduID.provisionEduid(new EduIDProvision(user.getEduId(), provisioning.getInstitutionGUID()));
            }
            String userRequest = this.prettyJson((Object)request);
            Optional provisioningResponse = this.newRequest(provisioning, userRequest, (Provisionable)user);
            provisioningResponse.ifPresent(response -> {
                if (!response.isErrorResponse() && StringUtils.hasText((String)response.remoteIdentifier())) {
                    RemoteProvisionedUser remoteProvisionedUser = new RemoteProvisionedUser(user, response.remoteIdentifier(), provisioning.getId());
                    this.remoteProvisionedUserRepository.save((Object)remoteProvisionedUser);
                }
                if (response.isGraphResponse()) {
                    graphResponseReference.set((GraphResponse)response);
                }
            });
        });
        return Optional.ofNullable((GraphResponse)graphResponseReference.get());
    }

    public void updateUserRequest(User user) {
        List userProvisionings = this.getProvisionings(user);
        List<Provisioning> provisionings = userProvisionings.stream().filter(provisioning -> provisioning.getProvisioningType().equals((Object)ProvisioningType.scim)).toList();
        provisionings.forEach(provisioning -> {
            Optional provisionedUserOptional = this.remoteProvisionedUserRepository.findByManageProvisioningIdAndUser(provisioning.getId(), user);
            provisionedUserOptional.ifPresent(remoteProvisionedUser -> {
                String userRequest = this.prettyJson((Object)new UserRequest(user, provisioning, remoteProvisionedUser.getRemoteIdentifier()));
                this.updateRequest(provisioning, userRequest, USER_API, remoteProvisionedUser.getRemoteIdentifier(), HttpMethod.PUT);
            });
        });
    }

    public void updateUserRoleRequest(UserRole userRole) {
        List<Provisioning> provisionings = this.getProvisionings(userRole.getUser()).stream().filter(provisioning -> provisioning.isApplicableForUserRoleRequests()).toList();
        provisionings.forEach(provisioning -> {
            RequestEntity requestEntity = this.evaClient.updateUserRequest(provisioning, userRole.getUser());
            this.doExchange(requestEntity, USER_API, this.stringParameterizedTypeReference, provisioning);
        });
    }

    public void deleteUserRoleRequest(UserRole userRole) {
        List<Provisioning> provisionings = this.getProvisionings(userRole.getUser()).stream().filter(provisioning -> provisioning.isApplicableForUserRoleRequests()).toList();
        provisionings.forEach(provisioning -> {
            RequestEntity requestEntity = this.evaClient.deleteUserRequest(provisioning, userRole.getUser());
            this.doExchange(requestEntity, USER_API, this.stringParameterizedTypeReference, provisioning);
        });
    }

    public void deleteUserRequest(User user) {
        user.getUserRoles().forEach(userRole -> this.updateGroupRequest(userRole, OperationType.Remove));
        List provisionings = this.getProvisionings(user);
        provisionings.forEach(provisioning -> {
            Optional provisionedUserOptional = this.remoteProvisionedUserRepository.findByManageProvisioningIdAndUser(provisioning.getId(), user);
            if (provisionedUserOptional.isPresent()) {
                RemoteProvisionedUser remoteProvisionedUser = (RemoteProvisionedUser)provisionedUserOptional.get();
                String remoteIdentifier = remoteProvisionedUser.getRemoteIdentifier();
                String userRequest = this.prettyJson((Object)new UserRequest(user, provisioning, remoteIdentifier));
                this.deleteRequest(provisioning, userRequest, (Provisionable)user, remoteIdentifier);
                this.remoteProvisionedUserRepository.delete((Object)remoteProvisionedUser);
            }
        });
    }

    public void newGroupRequest(Role role) {
        List provisionings = this.getProvisionings(role);
        provisionings.forEach(provisioning -> {
            Optional provisionedGroupOptional = this.remoteProvisionedGroupRepository.findByManageProvisioningIdAndRole(provisioning.getId(), role);
            if (provisionedGroupOptional.isEmpty()) {
                String groupRequest = this.constructGroupRequest(role, null, Collections.emptyList());
                Optional provisioningResponse = this.newRequest(provisioning, groupRequest, (Provisionable)role);
                provisioningResponse.ifPresent(response -> {
                    RemoteProvisionedGroup remoteProvisionedGroup = new RemoteProvisionedGroup(role, response.remoteIdentifier(), provisioning.getId());
                    this.remoteProvisionedGroupRepository.save((Object)remoteProvisionedGroup);
                });
            }
        });
    }

    public void updateGroupRequest(UserRole userRole, OperationType operationType) {
        if (!userRole.getAuthority().equals((Object)Authority.GUEST) && !userRole.isGuestRoleIncluded()) {
            return;
        }
        Role role = userRole.getRole();
        List<Provisioning> provisionings = this.getProvisionings(role).stream().filter(Provisioning::isApplicableForGroupRequest).toList();
        provisionings.forEach(provisioning -> {
            Optional provisionedGroupOptional = this.remoteProvisionedGroupRepository.findByManageProvisioningIdAndRole(provisioning.getId(), role);
            provisionedGroupOptional.ifPresentOrElse(provisionedGroup -> {
                List<UserRole> userRoles = new ArrayList<UserRole>();
                if (provisioning.isScimUpdateRolePutMethod()) {
                    userRoles = this.userRoleRepository.findByRole(userRole.getRole()).stream().filter(userRoleDB -> userRoleDB.getAuthority().equals((Object)Authority.GUEST) || userRoleDB.isGuestRoleIncluded()).collect(Collectors.toCollection(ArrayList::new));
                    boolean userRolePresent = userRoles.stream().anyMatch(dbUserRole -> dbUserRole.getId().equals(userRole.getId()));
                    if (operationType.equals((Object)OperationType.Add) && !userRolePresent) {
                        userRoles.add(userRole);
                    } else if (operationType.equals((Object)OperationType.Remove) && userRolePresent) {
                        userRoles = userRoles.stream().filter(dbUserRole -> !dbUserRole.getId().equals(userRole.getId())).collect(Collectors.toCollection(ArrayList::new));
                    }
                } else {
                    userRoles.add(userRole);
                }
                this.sendGroupPutRequest(provisioning, provisionedGroup, userRoles, role, operationType);
            }, () -> {
                this.newGroupRequest(role);
                this.updateGroupRequest(userRole, operationType);
            });
        });
    }

    private void sendGroupPutRequest(Provisioning provisioning, RemoteProvisionedGroup provisionedGroup, List<UserRole> userRoles, Role role, OperationType operationType) {
        List<String> userScimIdentifiers = userRoles.stream().map(userRole -> this.remoteProvisionedUserRepository.findByManageProvisioningIdAndUser(provisioning.getId(), userRole.getUser()).or(() -> {
            this.newUserRequest(userRole.getUser());
            return this.remoteProvisionedUserRepository.findByManageProvisioningIdAndUser(provisioning.getId(), userRole.getUser());
        })).filter(Optional::isPresent).map(Optional::get).map(RemoteProvisionedUser::getRemoteIdentifier).toList();
        if (!userScimIdentifiers.isEmpty()) {
            if (provisioning.isScimUpdateRolePutMethod()) {
                String groupRequest = this.constructGroupRequest(role, provisionedGroup.getRemoteIdentifier(), userScimIdentifiers);
                this.updateRequest(provisioning, groupRequest, GROUP_API, provisionedGroup.getRemoteIdentifier(), HttpMethod.PUT);
            } else {
                String groupRequest = this.patchGroupRequest(role, userScimIdentifiers, provisionedGroup.getRemoteIdentifier(), operationType);
                this.updateRequest(provisioning, groupRequest, GROUP_API, provisionedGroup.getRemoteIdentifier(), HttpMethod.PATCH);
            }
        }
    }

    public void updateGroupRequest(List<String> previousManageIdentifiers, Role newRole, boolean nameChanged) {
        List previousManageIdentifiersSorted = previousManageIdentifiers.stream().sorted().toList();
        List newManageIdentifiers = this.getManageIdentifiers(newRole);
        if (!nameChanged && previousManageIdentifiers.equals(newManageIdentifiers)) {
            LOG.info((Object)String.format("Group %s update request with no difference in manage identifiers (%s). No action required", newRole.getName(), newManageIdentifiers));
            return;
        }
        LOG.info((Object)String.format("Group %s update request with different manage identifiers. Old identifiers %s, new identifiers %s", newRole.getName(), previousManageIdentifiers, newManageIdentifiers));
        List<String> addedManageIdentifiers = newManageIdentifiers.stream().filter(id -> !previousManageIdentifiersSorted.contains(id) || nameChanged).toList();
        List<String> deletedManageIdentifiers = previousManageIdentifiers.stream().filter(id -> !newManageIdentifiers.contains(id)).toList();
        this.manage.provisioning(addedManageIdentifiers).stream().map(Provisioning::new).forEach(provisioning -> {
            Optional provisionedGroupOptional = this.remoteProvisionedGroupRepository.findByManageProvisioningIdAndRole(provisioning.getId(), newRole);
            if (provisionedGroupOptional.isEmpty()) {
                this.newGroupRequest(newRole);
                provisionedGroupOptional = this.remoteProvisionedGroupRepository.findByManageProvisioningIdAndRole(provisioning.getId(), newRole);
            }
            provisionedGroupOptional.ifPresent(provisionedGroup -> {
                List userRoles = this.userRoleRepository.findByRole(newRole);
                this.sendGroupPutRequest(provisioning, provisionedGroup, userRoles, newRole, OperationType.Add);
            });
        });
        LOG.info((Object)String.format("Deleting existing provisionings %s from group %s", deletedManageIdentifiers, newRole.getName()));
        List<Provisioning> provisionings = this.manage.provisioning(deletedManageIdentifiers).stream().map(Provisioning::new).toList();
        this.deleteGroupRequest(newRole, provisionings);
    }

    public void deleteGroupRequest(Role role) {
        List provisionings = this.getProvisionings(role);
        this.deleteGroupRequest(role, provisionings);
    }

    private void deleteGroupRequest(Role role, List<Provisioning> provisionings) {
        provisionings.forEach(provisioning -> this.remoteProvisionedGroupRepository.findByManageProvisioningIdAndRole(provisioning.getId(), role).ifPresent(remoteProvisionedGroup -> {
            String remoteIdentifier = remoteProvisionedGroup.getRemoteIdentifier();
            String externalId = GroupURN.urnFromRole((String)this.groupUrnPrefix, (Role)role);
            String groupRequest = this.prettyJson((Object)new GroupRequest(externalId, remoteIdentifier, role.getName(), Collections.emptyList()));
            this.deleteRequest(provisioning, groupRequest, (Provisionable)role, remoteIdentifier);
            this.remoteProvisionedGroupRepository.delete(remoteProvisionedGroup);
        }));
    }

    private String constructGroupRequest(Role role, String remoteGroupScimIdentifier, List<String> remoteUserScimIdentifiers) {
        HashSet<String> uniqueRemoteUserScimIdentifiers = new HashSet<String>(remoteUserScimIdentifiers);
        List<Member> members = uniqueRemoteUserScimIdentifiers.stream().filter(StringUtils::hasText).map(Member::new).toList();
        String externalId = GroupURN.urnFromRole((String)this.groupUrnPrefix, (Role)role);
        return this.prettyJson((Object)new GroupRequest(externalId, remoteGroupScimIdentifier, role.getName(), members));
    }

    private String patchGroupRequest(Role role, List<String> remoteScimProvisionedUsers, String remoteScimProvisionedGroup, OperationType operationType) {
        String externalId = GroupURN.urnFromRole((String)this.groupUrnPrefix, (Role)role);
        GroupPatchRequest request = new GroupPatchRequest(externalId, remoteScimProvisionedGroup, new Operation(operationType, remoteScimProvisionedUsers));
        return this.prettyJson((Object)request);
    }

    private Optional<ProvisioningResponse> newRequest(Provisioning provisioning, String request, Provisionable provisionable) {
        boolean isUser = provisionable instanceof User;
        String apiType = isUser ? USER_API : GROUP_API;
        RequestEntity requestEntity = null;
        if (this.hasEvaHook(provisioning) && isUser) {
            LOG.info((Object)String.format("Provisioning new eva account for user %s and provisioning %s", ((User)provisionable).getEmail(), provisioning.getEntityId()));
            requestEntity = this.evaClient.newUserRequest(provisioning, (User)provisionable);
        } else if (this.hasScimHook(provisioning)) {
            LOG.info((Object)String.format("Provisioning new SCIM account for provisionable %s and provisioning %s", provisionable.getName(), provisioning.getEntityId()));
            URI uri = this.provisioningUri(provisioning, apiType, Optional.empty());
            requestEntity = new RequestEntity((Object)request, (MultiValueMap)this.httpHeaders(provisioning), HttpMethod.POST, uri);
        } else if (this.hasGraphHook(provisioning) && isUser) {
            LOG.info((Object)String.format("Provisioning new Graph user for provisionable %s and provisioning %s", ((User)provisionable).getEmail(), provisioning.getEntityId()));
            GraphResponse graphResponse = this.graphClient.newUserRequest(provisioning, (User)provisionable);
            return Optional.of(graphResponse);
        }
        if (requestEntity != null) {
            Map results = (Map)this.doExchange(requestEntity, apiType, this.mapParameterizedTypeReference, provisioning);
            return Optional.of(new DefaultProvisioningResponse(String.valueOf(results.get("id"))));
        }
        return Optional.empty();
    }

    private void updateRequest(Provisioning provisioning, String request, String apiType, String remoteIdentifier, HttpMethod httpMethod) {
        if (this.hasScimHook(provisioning)) {
            URI uri = this.provisioningUri(provisioning, apiType, Optional.ofNullable(remoteIdentifier));
            RequestEntity requestEntity = new RequestEntity((Object)request, (MultiValueMap)this.httpHeaders(provisioning), httpMethod, uri);
            this.doExchange(requestEntity, apiType, this.mapParameterizedTypeReference, provisioning);
        }
    }

    private List<Provisioning> getProvisionings(User user) {
        Set manageIdentifiers = user.manageIdentifierSet();
        List<String> identifiers = manageIdentifiers.stream().map(ManageIdentifier::manageId).toList();
        return this.manage.provisioning(identifiers).stream().map(Provisioning::new).toList();
    }

    private List<Provisioning> getProvisionings(Role role) {
        List manageIdentifiers = this.getManageIdentifiers(role);
        return this.manage.provisioning((Collection)manageIdentifiers).stream().map(Provisioning::new).toList();
    }

    private List<String> getManageIdentifiers(Role role) {
        return role.applicationsUsed().stream().map(Application::getManageId).distinct().sorted().toList();
    }

    private void deleteRequest(Provisioning provisioning, String request, Provisionable provisionable, String remoteIdentifier) {
        boolean isUser = provisionable instanceof User;
        String apiType = isUser ? USER_API : GROUP_API;
        RequestEntity requestEntity = null;
        if (this.hasEvaHook(provisioning) && isUser) {
            requestEntity = this.evaClient.deleteUserRequest(provisioning, (User)provisionable);
        } else if (this.hasScimHook(provisioning)) {
            URI uri = this.provisioningUri(provisioning, apiType, Optional.ofNullable(remoteIdentifier));
            HttpHeaders headers = this.httpHeaders(provisioning);
            headers.setBasicAuth(provisioning.getScimUser(), this.decryptScimPassword(provisioning));
            requestEntity = new RequestEntity((Object)request, (MultiValueMap)headers, HttpMethod.DELETE, uri);
        } else if (this.hasGraphHook(provisioning) && isUser) {
            this.graphClient.deleteUser((User)provisionable, provisioning, remoteIdentifier);
        }
        if (requestEntity != null) {
            this.doExchange(requestEntity, apiType, this.stringParameterizedTypeReference, provisioning);
        }
    }

    private <T, S> T doExchange(RequestEntity<S> requestEntity, String api, ParameterizedTypeReference<T> typeReference, Provisioning provisioning) {
        try {
            LOG.info((Object)String.format("Send %s Provisioning request (protocol %s) with %s httpMethod %s and body %s to %s", api, provisioning.getProvisioningType(), requestEntity.getMethod(), requestEntity.getUrl(), requestEntity.getBody(), provisioning.getEntityId()));
            return (T)this.restTemplate.exchange(requestEntity, typeReference).getBody();
        }
        catch (RestClientException e) {
            LOG.error((Object)String.format("Error from %s with original stack-trace", provisioning.getEntityId()), (Throwable)e);
            String errorMessage = String.format("Error %s SCIM request (entityID %s) to %s with %s httpMethod and body %s", api, provisioning.getEntityId(), requestEntity.getUrl(), requestEntity.getMethod(), requestEntity.getBody());
            throw new RemoteException(HttpStatus.BAD_REQUEST, errorMessage, (Throwable)e);
        }
    }

    private boolean hasEvaHook(Provisioning provisioning) {
        return provisioning.getProvisioningType().equals((Object)ProvisioningType.eva);
    }

    private boolean hasScimHook(Provisioning provisioning) {
        return provisioning.getProvisioningType().equals((Object)ProvisioningType.scim);
    }

    private boolean hasGraphHook(Provisioning provisioning) {
        return provisioning.getProvisioningType().equals((Object)ProvisioningType.graph);
    }

    private URI provisioningUri(Provisioning provisioning, String objectType, Optional<String> remoteIdentifier) {
        String postFix = remoteIdentifier.map(identifier -> "/" + identifier).orElse("");
        return URI.create(String.format("%s/%s%s", provisioning.getScimUrl(), objectType, postFix));
    }

    private String prettyJson(Object obj) {
        return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(obj);
    }

    private String decryptScimPassword(Provisioning provisioning) {
        String scimPassword = provisioning.getScimPassword();
        return this.keyStore.isEncryptedSecret(scimPassword) ? this.keyStore.decodeAndDecrypt(scimPassword) : scimPassword;
    }

    private HttpHeaders httpHeaders(Provisioning provisioning) {
        HttpHeaders headers = new HttpHeaders();
        switch (3.$SwitchMap$access$provision$ProvisioningType[provisioning.getProvisioningType().ordinal()]) {
            case 1: {
                headers.setBasicAuth(provisioning.getScimUser(), this.decryptScimPassword(provisioning));
                headers.setContentType(MediaType.APPLICATION_JSON);
                headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
                break;
            }
            case 2: {
                headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
                headers.add("X-Api-Key", provisioning.getEvaToken());
            }
        }
        return headers;
    }
}

