/*
 * Decompiled with CFR 0.152.
 */
package access.repository;

import access.model.Role;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

@Repository
public interface RoleRepository
extends JpaRepository<Role, Long> {
    @Query(value="SELECT *, (SELECT COUNT(*) FROM user_roles ur WHERE ur.role_id=r.id) as userRoleCount FROM roles r WHERE MATCH (name, description) against (?1  IN BOOLEAN MODE) AND id > 0 LIMIT ?2", nativeQuery=true)
    public List<Role> search(String var1, int var2);

    @Query(value="SELECT r.id, r.name, r.description, a.manage_id, a.manage_type,\n    (SELECT COUNT(*) FROM user_roles ur WHERE ur.role_id=r.id) as userRoleCount\nFROM roles r INNER JOIN application_usages au on au.role_id = r.id\n    INNER JOIN applications a on au.application_id = a.id\n", countQuery="SELECT COUNT(r.id) FROM roles r\n", nativeQuery=true)
    public Page<Map<String, Object>> searchByPage(Pageable var1);

    @Query(value="SELECT r.id, r.name, r.description, a.manage_id, a.manage_type,\n    (SELECT COUNT(*) FROM user_roles ur WHERE ur.role_id=r.id) as userRoleCount\nFROM roles r INNER JOIN application_usages au on au.role_id = r.id\n    INNER JOIN applications a on au.application_id = a.id\nWHERE MATCH (name, description) against (?1 IN BOOLEAN MODE)\n", countQuery="SELECT COUNT(r.id) FROM roles r WHERE MATCH (name, description) against (?1 IN BOOLEAN MODE)\n", nativeQuery=true)
    public Page<Map<String, Object>> searchByPageWithKeyword(String var1, Pageable var2);

    public List<Role> findByApplicationUsagesApplicationManageId(String var1);

    public List<Role> findByOrganizationGUID(String var1);

    public Optional<Role> findByName(String var1);
}

