/*
 * Decompiled with CFR 0.152.
 */
package access.repository;

import access.model.User;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

@Repository
public interface UserRepository
extends JpaRepository<User, Long> {
    public Optional<User> findBySubIgnoreCase(String var1);

    public List<User> findByOrganizationGUIDAndInstitutionAdmin(String var1, boolean var2);

    public List<User> findBySuperUserTrue();

    public Optional<User> findByEduPersonPrincipalNameIgnoreCase(String var1);

    public Optional<User> findByEmailIgnoreCase(String var1);

    public List<User> findByLastActivityBefore(Instant var1);

    @Query(value="SELECT * FROM users WHERE MATCH (given_name, family_name, email) against (?1  IN BOOLEAN MODE) AND id > 0 LIMIT ?2", nativeQuery=true)
    public List<User> search(String var1, int var2);

    @Query(value="SELECT u.id, u.email, u.name, u.schac_home_organization, u.created_at, u.last_activity, ur.authority, r.name AS role_name, r.id AS role_id, ur.end_date FROM users u INNER JOIN user_roles ur ON ur.user_id = u.id INNER JOIN roles r ON r.id = ur.role_id INNER JOIN application_usages au ON au.role_id = r.id INNER JOIN applications a ON a.id = au.application_id WHERE a.manage_id in ?1 AND MATCH (u.given_name, u.family_name, u.email) AGAINST (?2  IN BOOLEAN MODE) LIMIT ?3", nativeQuery=true)
    public List<Map<String, Object>> searchByApplication(List<String> var1, String var2, int var3);

    @Query(value=" select u.name, u.email, u.schac_home_organization, u.sub, u.super_user, u.institution_admin,\n    (SELECT GROUP_CONCAT(DISTINCT ur.authority) FROM user_roles ur WHERE ur.user_id = u.id) AS authority from users u\n", countQuery="SELECT count(*) FROM users", nativeQuery=true)
    public Page<Map<String, Object>> searchByPage(Pageable var1);

    @Query(value=" select u.name, u.email, u.schac_home_organization, u.sub, u.super_user, u.institution_admin,\n    (SELECT GROUP_CONCAT(DISTINCT ur.authority) FROM user_roles ur WHERE ur.user_id = u.id) AS authority\n from users u WHERE MATCH (given_name, family_name, email) against (?1  IN BOOLEAN MODE)\n", countQuery="SELECT count(*) FROM users WHERE MATCH (given_name, family_name, email) against (?1  IN BOOLEAN MODE)", nativeQuery=true)
    public Page<Map<String, Object>> searchByPageWithKeyword(String var1, Pageable var2);

    @Query(value="SELECT u.id, u.email, u.name, u.schac_home_organization, u.created_at, u.last_activity, ur.authority, r.name AS role_name, r.id AS role_id, ur.end_date FROM users u INNER JOIN user_roles ur ON ur.user_id = u.id INNER JOIN roles r ON r.id = ur.role_id INNER JOIN application_usages au ON au.role_id = r.id INNER JOIN applications a ON a.id = au.application_id WHERE a.manage_id in ?1", nativeQuery=true)
    public List<Map<String, Object>> searchByApplicationAllUsers(List<String> var1);

    @Query(value="SELECT * FROM users u WHERE super_user = 0 AND institution_admin = 0 AND NOT EXISTS (SELECT ur.id FROM user_roles ur WHERE ur.user_id = u.id)", nativeQuery=true)
    public List<User> findNonSuperUserWithoutUserRoles();
}

