/*
 * Decompiled with CFR 0.152.
 */
package access.api;

import access.api.InvitationOperations;
import access.api.InvitationResource;
import access.api.Results;
import access.exception.InvitationEmailMatchingException;
import access.exception.InvitationExpiredException;
import access.exception.InvitationStatusException;
import access.exception.NotFoundException;
import access.logging.AccessLogger;
import access.logging.Event;
import access.mail.MailBox;
import access.manage.Manage;
import access.model.AcceptInvitation;
import access.model.Authority;
import access.model.Invitation;
import access.model.InvitationRequest;
import access.model.InvitationResponse;
import access.model.InvitationRole;
import access.model.Role;
import access.model.Status;
import access.model.User;
import access.model.UserRole;
import access.provision.Provisioning;
import access.provision.ProvisioningService;
import access.provision.scim.OperationType;
import access.repository.InvitationRepository;
import access.repository.RoleRepository;
import access.repository.UserRepository;
import access.security.SuperAdmin;
import access.security.UserPermissions;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.security.SecurityRequirements;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;
import org.springframework.security.oauth2.core.oidc.OidcUserInfo;
import org.springframework.security.oauth2.core.oidc.user.DefaultOidcUser;
import org.springframework.security.oauth2.core.user.OAuth2User;
import org.springframework.security.web.context.SecurityContextRepository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/invitations", "/api/external/v1/invitations"}, produces={"application/json"})
@Transactional
@SecurityRequirements(value={@SecurityRequirement(name="openId", scopes={"openid"}), @SecurityRequirement(name="apiTokens")})
@EnableConfigurationProperties(value={SuperAdmin.class})
public class InvitationController
implements InvitationResource {
    private static final Log LOG = LogFactory.getLog(InvitationController.class);
    private final MailBox mailBox;
    private final Manage manage;
    private final InvitationRepository invitationRepository;
    private final RoleRepository roleRepository;
    private final UserRepository userRepository;
    private final ProvisioningService provisioningService;
    private final SecurityContextRepository securityContextRepository;
    private final SuperAdmin superAdmin;
    private final InvitationOperations invitationOperations;

    public InvitationController(MailBox mailBox, Manage manage, InvitationRepository invitationRepository, UserRepository userRepository, RoleRepository roleRepository, ProvisioningService provisioningService, SecurityContextRepository securityContextRepository, SuperAdmin superAdmin) {
        this.mailBox = mailBox;
        this.manage = manage;
        this.invitationRepository = invitationRepository;
        this.userRepository = userRepository;
        this.roleRepository = roleRepository;
        this.provisioningService = provisioningService;
        this.securityContextRepository = securityContextRepository;
        this.superAdmin = superAdmin;
        this.invitationOperations = new InvitationOperations((InvitationResource)this);
    }

    @PostMapping(value={""})
    public ResponseEntity<InvitationResponse> newInvitation(@Validated @RequestBody InvitationRequest invitationRequest, @Parameter(hidden=true) User user) {
        return this.invitationOperations.sendInvitation(invitationRequest, user, null);
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> deleteInvitation(@PathVariable(value="id") Long id, @Parameter(hidden=true) User user) {
        LOG.debug((Object)String.format("/deleteInvitation/%s by user %s", id, user.getEduPersonPrincipalName()));
        Invitation invitation = (Invitation)this.invitationRepository.findById((Object)id).orElseThrow(() -> new NotFoundException("Invitation not found"));
        List<Role> requestedRoles = invitation.getRoles().stream().map(InvitationRole::getRole).toList();
        Authority intendedAuthority = invitation.getIntendedAuthority();
        UserPermissions.assertValidInvitation((User)user, (Authority)intendedAuthority, requestedRoles);
        AccessLogger.invitation((Log)LOG, (Event)Event.Deleted, (Invitation)invitation);
        this.invitationRepository.delete((Object)invitation);
        return Results.deleteResult();
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<Map<String, Integer>> resendInvitation(@PathVariable(value="id") Long id, @Parameter(hidden=true) User user) {
        return this.invitationOperations.resendInvitation(id, user, null);
    }

    @GetMapping(value={"public"})
    public ResponseEntity<Invitation> getInvitation(@RequestParam(value="hash") String hash) {
        Invitation invitation = (Invitation)this.invitationRepository.findByHash(hash).orElseThrow(() -> new NotFoundException("Invitation not found"));
        if (!invitation.getStatus().equals((Object)Status.OPEN)) {
            throw new InvitationStatusException("Invitation is not OPEN anymore");
        }
        this.manage.addManageMetaData(invitation.getRoles().stream().map(InvitationRole::getRole).toList());
        return ResponseEntity.ok((Object)invitation);
    }

    @GetMapping(value={"all"})
    public ResponseEntity<List<Invitation>> all(@Parameter(hidden=true) User user) {
        LOG.debug((Object)"/all invitations");
        UserPermissions.assertAuthority((User)user, (Authority)Authority.INVITER);
        if (user.isSuperUser()) {
            return ResponseEntity.ok((Object)this.invitationRepository.findByStatus(Status.OPEN));
        }
        List<Role> roles = user.getUserRoles().stream().map(UserRole::getRole).toList();
        return ResponseEntity.ok((Object)this.invitationRepository.findByRoles_roleIsIn(roles));
    }

    @PostMapping(value={"accept"})
    public ResponseEntity<Map<String, Object>> accept(@Validated @RequestBody AcceptInvitation acceptInvitation, Authentication authentication, HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        Optional optionalGraphResponse;
        Invitation invitation = (Invitation)this.invitationRepository.findByHash(acceptInvitation.hash()).orElseThrow(() -> new NotFoundException("Invitation not found"));
        if (!invitation.getId().equals(acceptInvitation.invitationId())) {
            throw new NotFoundException("Invitation not found");
        }
        if (!invitation.getStatus().equals((Object)Status.OPEN)) {
            throw new InvitationStatusException("Invitation is not OPEN anymore");
        }
        if (invitation.getExpiryDate().isBefore(Instant.now())) {
            throw new InvitationExpiredException("Invitation has expired");
        }
        OAuth2AuthenticationToken token = (OAuth2AuthenticationToken)authentication;
        Map attributes = token.getPrincipal().getAttributes();
        String sub = (String)attributes.get("sub");
        Optional optionalUser = this.userRepository.findBySubIgnoreCase(sub);
        Authority intendedAuthority = invitation.getIntendedAuthority();
        User user = optionalUser.orElseGet(() -> {
            boolean superUser = this.superAdmin.getUsers().stream().anyMatch(superSub -> superSub.equals(sub)) || intendedAuthority.equals((Object)Authority.SUPER_USER);
            return new User(superUser, attributes);
        });
        this.checkEmailEquality(user, invitation);
        user.setLastActivity(Instant.now());
        invitation.setStatus(Status.ACCEPTED);
        invitation.setAcceptedAt(Instant.now());
        invitation.setSubInvitee(sub);
        this.invitationRepository.save((Object)invitation);
        AccessLogger.invitation((Log)LOG, (Event)Event.Accepted, (Invitation)invitation);
        ArrayList newUserRoles = new ArrayList();
        User inviter = invitation.getInviter();
        invitation.getRoles().forEach(invitationRole -> {
            Role role = invitationRole.getRole();
            Optional<UserRole> optionalUserRole = user.getUserRoles().stream().filter(userRole -> userRole.getRole().getId().equals(role.getId())).findFirst();
            if (optionalUserRole.isPresent()) {
                UserRole userRole2 = optionalUserRole.get();
                Authority currentAuthority = userRole2.getAuthority();
                if (!currentAuthority.equals((Object)intendedAuthority)) {
                    if (intendedAuthority.hasHigherRights(currentAuthority)) {
                        userRole2.setAuthority(intendedAuthority);
                        userRole2.setEndDate(invitation.getRoleExpiryDate());
                    }
                    if (currentAuthority.equals((Object)Authority.GUEST) || intendedAuthority.equals((Object)Authority.GUEST) || invitation.isGuestRoleIncluded()) {
                        userRole2.setGuestRoleIncluded(true);
                    }
                }
            } else {
                UserRole userRole3 = new UserRole(inviter.getName(), user, role, intendedAuthority, invitation.isGuestRoleIncluded(), invitation.getRoleExpiryDate());
                user.addUserRole(userRole3);
                newUserRoles.add(userRole3);
            }
        });
        if (intendedAuthority.equals((Object)Authority.INSTITUTION_ADMIN)) {
            user.setInstitutionAdmin(true);
            user.setInstitutionAdminByInvite(true);
            user.setOrganizationGUID(inviter.getOrganizationGUID());
            if (optionalUser.isEmpty()) {
                this.saveOAuth2AuthenticationToken(authentication, user, servletRequest, servletResponse);
            }
        }
        this.userRepository.save((Object)user);
        AccessLogger.user((Log)LOG, (Event)Event.Created, (User)user);
        boolean isGuest = user.getUserRoles().stream().anyMatch(userRole -> userRole.isGuestRoleIncluded() || userRole.getAuthority().equals((Object)Authority.GUEST));
        Optional optional = optionalGraphResponse = isGuest ? this.provisioningService.newUserRequest(user) : Optional.empty();
        if (isGuest) {
            newUserRoles.forEach(userRole -> this.provisioningService.updateGroupRequest(userRole, OperationType.Add));
        }
        LOG.info((Object)String.format("User %s accepted invitation with role(s) %s", user.getEduPersonPrincipalName(), invitation.getRoles().stream().map(role -> role.getRole().getName()).collect(Collectors.joining(", "))));
        HashMap body = new HashMap();
        optionalGraphResponse.ifPresentOrElse(graphResponse -> {
            if (graphResponse.isErrorResponse()) {
                body.put("errorResponse", Boolean.TRUE);
            } else {
                body.put("inviteRedeemUrl", graphResponse.inviteRedeemUrl());
            }
        }, () -> body.put("status", "ok"));
        if (!isGuest) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body(body);
        }
        List provisionings = this.provisioningService.getProvisionings(newUserRoles);
        provisionings.stream().filter(provisioning -> provisioning.getUserWaitTime() != null).max(Comparator.comparingInt(Provisioning::getUserWaitTime)).ifPresent(provisioning -> {
            Set manageIdentifiers = provisioning.getRemoteApplications().stream().map(app -> app.manageId()).collect(Collectors.toSet());
            newUserRoles.stream().filter(userRole -> userRole.getRole().getApplicationUsages().stream().anyMatch(appUsage -> manageIdentifiers.contains(appUsage.getApplication().getManageId()))).map(userRole -> userRole.getRole()).sorted(Comparator.comparing(Role::getName)).findFirst().ifPresent(role -> {
                body.put("userWaitTime", provisioning.getUserWaitTime());
                body.put("role", role.getName());
            });
        });
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body(body);
    }

    private void saveOAuth2AuthenticationToken(Authentication authentication, User user, HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        OAuth2AuthenticationToken existingToken = (OAuth2AuthenticationToken)authentication;
        DefaultOidcUser existingTokenPrincipal = (DefaultOidcUser)existingToken.getPrincipal();
        HashMap claims = new HashMap(existingTokenPrincipal.getClaims());
        claims.putAll(this.manage.enrichInstitutionAdmin(user.getOrganizationGUID()));
        DefaultOidcUser oidcUser = new DefaultOidcUser(existingToken.getAuthorities(), existingTokenPrincipal.getIdToken(), new OidcUserInfo(claims));
        OAuth2AuthenticationToken newToken = new OAuth2AuthenticationToken((OAuth2User)oidcUser, existingToken.getAuthorities(), existingToken.getAuthorizedClientRegistrationId());
        SecurityContextHolder.getContext().setAuthentication((Authentication)newToken);
        this.securityContextRepository.saveContext(SecurityContextHolder.getContext(), servletRequest, servletResponse);
    }

    @GetMapping(value={"roles/{roleId}"})
    public ResponseEntity<List<Invitation>> byRole(@PathVariable(value="roleId") Long roleId, @Parameter(hidden=true) User user) {
        LOG.debug((Object)String.format("/roles/%s by user %s", roleId, user.getEduPersonPrincipalName()));
        Role role = (Role)this.roleRepository.findById((Object)roleId).orElseThrow(() -> new NotFoundException("Role not found"));
        UserPermissions.assertRoleAccess((User)user, (Role)role, (Authority)Authority.INVITER);
        List invitations = this.invitationRepository.findByStatusAndRoles_role(Status.OPEN, role);
        return ResponseEntity.ok((Object)invitations);
    }

    private void checkEmailEquality(User user, Invitation invitation) {
        if (invitation.isEnforceEmailEquality() && !invitation.getEmail().equalsIgnoreCase(user.getEmail())) {
            throw new InvitationEmailMatchingException(String.format("Invitation email %s does not match user email %s", invitation.getEmail(), user.getEmail()));
        }
    }

    @Generated
    public MailBox getMailBox() {
        return this.mailBox;
    }

    @Generated
    public Manage getManage() {
        return this.manage;
    }

    @Generated
    public InvitationRepository getInvitationRepository() {
        return this.invitationRepository;
    }

    @Generated
    public RoleRepository getRoleRepository() {
        return this.roleRepository;
    }
}

