/*
 * Decompiled with CFR 0.152.
 */
package access.internal;

import access.api.ApplicationResource;
import access.api.InvitationOperations;
import access.api.InvitationResource;
import access.api.Results;
import access.api.RoleOperations;
import access.api.UserRoleOperations;
import access.api.UserRoleResource;
import access.exception.NotFoundException;
import access.logging.AccessLogger;
import access.logging.Event;
import access.mail.MailBox;
import access.manage.Manage;
import access.model.InvitationRequest;
import access.model.InvitationResponse;
import access.model.Provisionable;
import access.model.Role;
import access.model.StatusResponse;
import access.model.UserRole;
import access.provision.ProvisioningService;
import access.provision.scim.GroupURN;
import access.repository.ApplicationRepository;
import access.repository.ApplicationUsageRepository;
import access.repository.InvitationRepository;
import access.repository.RoleRepository;
import access.repository.UserRoleRepository;
import access.security.RemoteUser;
import access.security.RemoteUserPermissions;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/internal/invite", "/api/external/v1/internal/invite"}, produces={"application/json"})
@SecurityRequirement(name="basic_auth")
public class InternalInviteController
implements ApplicationResource,
InvitationResource,
UserRoleResource {
    private static final Log LOG = LogFactory.getLog(InternalInviteController.class);
    private final RoleRepository roleRepository;
    private final UserRoleRepository userRoleRepository;
    private final ApplicationRepository applicationRepository;
    private final ApplicationUsageRepository applicationUsageRepository;
    private final MailBox mailBox;
    private final Manage manage;
    private final InvitationRepository invitationRepository;
    private final ProvisioningService provisioningService;
    private final RoleOperations roleOperations;
    private final InvitationOperations invitationOperations;
    private final UserRoleOperations userRoleOperations;
    private final String groupUrnPrefix;

    public InternalInviteController(RoleRepository roleRepository, UserRoleRepository userRoleRepository, ApplicationRepository applicationRepository, ApplicationUsageRepository applicationUsageRepository, MailBox mailBox, Manage manage, InvitationRepository invitationRepository, ProvisioningService provisioningService, @Value(value="${voot.group_urn_domain}") String groupUrnPrefix) {
        this.roleRepository = roleRepository;
        this.userRoleRepository = userRoleRepository;
        this.applicationRepository = applicationRepository;
        this.applicationUsageRepository = applicationUsageRepository;
        this.mailBox = mailBox;
        this.manage = manage;
        this.invitationRepository = invitationRepository;
        this.provisioningService = provisioningService;
        this.groupUrnPrefix = groupUrnPrefix;
        this.userRoleOperations = new UserRoleOperations((UserRoleResource)this);
        this.roleOperations = new RoleOperations((ApplicationResource)this);
        this.invitationOperations = new InvitationOperations((InvitationResource)this);
    }

    @GetMapping(value={"/roles"})
    @PreAuthorize(value="hasAnyRole('SP_DASHBOARD')")
    @Hidden
    public ResponseEntity<List<Role>> rolesByApplication(@Parameter(hidden=true) @AuthenticationPrincipal RemoteUser remoteUser) {
        LOG.debug((Object)String.format("/roles for user %s", remoteUser.getName()));
        List roles = remoteUser.getApplications().stream().map(application -> this.roleRepository.findByApplicationUsagesApplicationManageId(application.getManageId())).flatMap(Collection::stream).toList();
        this.manage.addManageMetaData(roles);
        return ResponseEntity.ok(roles);
    }

    @GetMapping(value={"/roles/{id}"})
    @PreAuthorize(value="hasRole('SP_DASHBOARD')")
    @Hidden
    public ResponseEntity<Role> role(@PathVariable(value="id") Long id, @Parameter(hidden=true) @AuthenticationPrincipal RemoteUser remoteUser) {
        LOG.debug((Object)String.format("/role/%s for user %s", id, remoteUser.getName()));
        Role role = (Role)this.roleRepository.findById((Object)id).orElseThrow(() -> new NotFoundException("Role not found"));
        RemoteUserPermissions.assertApplicationAccess((RemoteUser)remoteUser, (Role)role);
        this.manage.addManageMetaData(List.of(role));
        return ResponseEntity.ok((Object)role);
    }

    @PostMapping(value={"/roles"})
    @PreAuthorize(value="hasRole('SP_DASHBOARD')")
    @Operation(summary="Create a Role", description="Create a Role linked to a SP in Manage. Note that the required application object needs to be pre-configured during deployment.", requestBody=@RequestBody(useParameterTypeSchema=true, content={@Content(examples={@ExampleObject(value="{\n  \"name\": \"Required role name\",\n  \"shortName\": \"Required short name - may be copy of name\",\n  \"description\": \"Required role description\",\n  \"defaultExpiryDays\": 365,\n  \"applicationUsages\": [\n    {\n      \"landingPage\": \"http://landingpage.com\",\n      \"application\": {\n        \"manageId\": \"4\",\n        \"manageType\": \"SAML20_SP\"\n      }\n    }\n  ]\n}\n")})}), responses={@ApiResponse(responseCode="201", description="Created", content={@Content(schema=@Schema(implementation=Role.class), examples={@ExampleObject(value="{\n  \"id\": 42114,\n  \"name\": \"Required role name\",\n  \"shortName\": \"required_role_name\",\n  \"description\": \"Required role description\",\n  \"urn\": \"urn:mace:surf.nl:test.surfaccess.nl:74fd8059-7558-4454-8393-fd84f74c4907:required_role_name\",\n  \"defaultExpiryDays\": 365,\n  \"enforceEmailEquality\": false,\n  \"eduIDOnly\": false,\n  \"blockExpiryDate\": false,\n  \"overrideSettingsAllowed\": false,\n  \"teamsOrigin\": false,\n  \"identifier\": \"74fd8059-7558-4454-8393-fd84f74c4907\",\n  \"remoteApiUser\": \"SP Dashboard\",\n  \"applicationUsages\": [\n    {\n      \"id\": 49203,\n      \"landingPage\": \"http://landingpage.com\",\n      \"application\": {\n        \"id\": 41904,\n        \"manageId\": \"4\",\n        \"manageType\": \"SAML20_SP\"\n      }\n    }\n  ],\n  \"auditable\": {\n    \"createdAt\": 1729254283,\n    \"createdBy\": \"sp_dashboard\"\n  },\n  \"applicationMaps\": [\n    {\n      \"OrganizationName:en\": \"SURF bv\",\n      \"landingPage\": \"http://landingpage.com\",\n      \"logo\": \"https://static.surfconext.nl/media/idp/surfconext.png\",\n      \"entityid\": \"https://research\",\n      \"name:en\": \"Research EN\",\n      \"id\": \"4\",\n      \"_id\": \"4\",\n      \"type\": \"saml20_sp\",\n      \"url\": \"https://default-url-research.org\",\n      \"name:nl\": \"Research NL\"\n    }\n  ]\n}\n")})}), @ApiResponse(responseCode="400", description="BadRequest", content={@Content(schema=@Schema(implementation=StatusResponse.class), examples={@ExampleObject(value="{\n  \"timestamp\": 1717672263253,\n  \"status\": 400,\n  \"error\": \"BadRequest\",\n  \"exception\": \"access.exception.UserRestrictionException\",\n  \"message\": \"No access to application\",\n  \"path\": \"/api/internal/invite/invitations\"\n}\n")})})})
    public ResponseEntity<Role> newRole(@Validated @org.springframework.web.bind.annotation.RequestBody Role role, @Parameter(hidden=true) @AuthenticationPrincipal RemoteUser remoteUser) {
        role.setRemoteApiUser(remoteUser.getName());
        role.setShortName(GroupURN.sanitizeRoleShortName((String)role.getShortName()));
        role.setIdentifier(UUID.randomUUID().toString());
        LOG.debug((Object)String.format("New role '%s' by user %s", role.getName(), remoteUser.getName()));
        role.setUrn(GroupURN.urnFromRole((String)this.groupUrnPrefix, (Role)role));
        Role savedRole = this.saveOrUpdate(role, remoteUser);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)savedRole);
    }

    @PutMapping(value={"/roles"})
    @PreAuthorize(value="hasRole('SP_DASHBOARD')")
    @Hidden
    public ResponseEntity<Role> updateRole(@Validated @org.springframework.web.bind.annotation.RequestBody Role role, @Parameter(hidden=true) @AuthenticationPrincipal RemoteUser remoteUser) {
        LOG.debug((Object)String.format("Update role '%s' by user %s", role.getName(), remoteUser.getName()));
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)this.saveOrUpdate(role, remoteUser));
    }

    @DeleteMapping(value={"/roles/{id}"})
    @PreAuthorize(value="hasRole('SP_DASHBOARD')")
    @Operation(summary="Delete existing Role", description="Delete an existing role. The path parameter id is the id returned when creating the role.", parameters={@Parameter(name="id", in=ParameterIn.PATH, description="Unique database id of the role", required=true)}, responses={@ApiResponse(responseCode="204", description="No content"), @ApiResponse(responseCode="400", description="BadRequest", content={@Content(schema=@Schema(implementation=StatusResponse.class), examples={@ExampleObject(value="{\n  \"timestamp\": 1717672263253,\n  \"status\": 400,\n  \"error\": \"BadRequest\",\n  \"exception\": \"access.exception.UserRestrictionException\",\n  \"message\": \"No access to role\",\n  \"path\": \"/api/internal/roles/999\"\n}\n")})}), @ApiResponse(responseCode="404", description="Role not found", content={@Content(schema=@Schema(implementation=StatusResponse.class), examples={@ExampleObject(value="{\n  \"timestamp\": 1717672263253,\n  \"status\": 404,\n  \"error\": \"Not found\",\n  \"exception\": \"access.exception.NotFoundException\",\n  \"message\": \"Role not found\",\n  \"path\": \"/api/internal/roles/999\"\n}\n")})})})
    public ResponseEntity<Void> deleteRole(@PathVariable(value="id") Long id, @Parameter(hidden=true) @AuthenticationPrincipal RemoteUser remoteUser) {
        Role role = (Role)this.roleRepository.findById((Object)id).orElseThrow(() -> new NotFoundException("Role not found"));
        LOG.debug((Object)String.format("Delete role %s by user %s", role.getName(), remoteUser.getName()));
        this.manage.addManageMetaData(List.of(role));
        RemoteUserPermissions.assertApplicationAccess((RemoteUser)remoteUser, (Role)role);
        this.provisioningService.deleteGroupRequest(role);
        this.roleRepository.delete((Object)role);
        AccessLogger.role((Log)LOG, (Event)Event.Deleted, (Provisionable)remoteUser, (Role)role);
        return Results.deleteResult();
    }

    @PostMapping(value={"/invitations"})
    @PreAuthorize(value="hasRole('SP_DASHBOARD')")
    @Operation(summary="Invite member for existing Role", description="Invite a member for an existing role. An invitation email will be sent. Do not forget to set guestRoleIncluded to true.", requestBody=@RequestBody(useParameterTypeSchema=true, content={@Content(examples={@ExampleObject(value="{\n  \"intendedAuthority\": \"INVITER\",\n  \"message\": \"Personal message included in the email\",\n  \"language\": \"en\",\n  \"guestRoleIncluded\": true,\n  \"invites\": [\n    \"admin@service.org\"\n  ],\n  \"roleIdentifiers\": [\n    99\n  ],\n  \"roleExpiryDate\": 1760788376,\n  \"expiryDate\": 1730461976\n}\n")})}), responses={@ApiResponse(responseCode="201", description="Created", content={@Content(schema=@Schema(implementation=InvitationResponse.class), examples={@ExampleObject(value="{\n  \"status\": 201,\n  \"recipientInvitationURLs\": [\n    {\n      \"recipient\": \"admin@service.nl\",\n      \"invitationURL\": \"https://invite.test.surfconext.nl/invitation/accept?{hash}\"\n    }\n  ]\n}\n")})}), @ApiResponse(responseCode="400", description="BadRequest", content={@Content(schema=@Schema(implementation=StatusResponse.class), examples={@ExampleObject(value="{\n  \"timestamp\": 1717672263253,\n  \"status\": 400,\n  \"error\": \"BadRequest\",\n  \"exception\": \"access.exception.UserRestrictionException\",\n  \"message\": \"No access to application\",\n  \"path\": \"/api/internal/invite/invitations\"\n}\n")})}), @ApiResponse(responseCode="404", description="Role not found", content={@Content(schema=@Schema(implementation=StatusResponse.class), examples={@ExampleObject(value="{\n  \"timestamp\": 1717672263253,\n  \"status\": 404,\n  \"error\": \"Not found\",\n  \"exception\": \"access.exception.NotFoundException\",\n  \"message\": \"Role not found\",\n  \"path\": \"/api/internal/invite/invitations\"\n}\n")})})})
    public ResponseEntity<InvitationResponse> newInvitation(@Validated @org.springframework.web.bind.annotation.RequestBody InvitationRequest invitationRequest, @Parameter(hidden=true) @AuthenticationPrincipal RemoteUser remoteUser) {
        return this.invitationOperations.sendInvitation(invitationRequest, null, remoteUser);
    }

    @PutMapping(value={"/invitations/{id}"})
    @PreAuthorize(value="hasRole('SP_DASHBOARD')")
    @Hidden
    public ResponseEntity<Map<String, Integer>> resendInvitation(@PathVariable(value="id") Long id, @Parameter(hidden=true) @AuthenticationPrincipal RemoteUser remoteUser) {
        return this.invitationOperations.resendInvitation(id, null, remoteUser);
    }

    @GetMapping(value={"user_roles/{roleId}"})
    @PreAuthorize(value="hasRole('SP_DASHBOARD')")
    @Transactional
    @Hidden
    public ResponseEntity<List<UserRole>> byRole(@PathVariable(value="roleId") Long roleId, @Parameter(hidden=true) @AuthenticationPrincipal RemoteUser remoteUser) {
        return this.userRoleOperations.userRolesByRole(roleId, role -> RemoteUserPermissions.assertApplicationAccess((RemoteUser)remoteUser, (Role)role));
    }

    private Role saveOrUpdate(Role role, RemoteUser remoteUser) {
        this.roleOperations.assertValidRole(role);
        RemoteUserPermissions.assertApplicationAccess((RemoteUser)remoteUser, (Role)role);
        this.manage.addManageMetaData(List.of(role));
        boolean isNew = role.getId() == null;
        ArrayList previousApplicationIdentifiers = new ArrayList();
        boolean nameChanged = false;
        if (!isNew) {
            Role previousRole = (Role)this.roleRepository.findById((Object)role.getId()).orElseThrow(() -> new NotFoundException("Role not found"));
            role.setShortName(previousRole.getShortName());
            role.setIdentifier(previousRole.getIdentifier());
            role.setOrganizationGUID(previousRole.getOrganizationGUID());
            previousApplicationIdentifiers.addAll(previousRole.applicationIdentifiers());
            nameChanged = !previousRole.getName().equals(role.getName());
        }
        this.roleOperations.syncRoleApplicationUsages(role);
        Role saved = (Role)this.roleRepository.save((Object)role);
        if (isNew) {
            this.provisioningService.newGroupRequest(saved);
        } else {
            this.provisioningService.updateGroupRequest(previousApplicationIdentifiers, saved, nameChanged);
        }
        AccessLogger.role((Log)LOG, (Event)(isNew ? Event.Created : Event.Updated), (Provisionable)remoteUser, (Role)role);
        return saved;
    }

    @Generated
    public RoleRepository getRoleRepository() {
        return this.roleRepository;
    }

    @Generated
    public UserRoleRepository getUserRoleRepository() {
        return this.userRoleRepository;
    }

    @Generated
    public ApplicationRepository getApplicationRepository() {
        return this.applicationRepository;
    }

    @Generated
    public ApplicationUsageRepository getApplicationUsageRepository() {
        return this.applicationUsageRepository;
    }

    @Generated
    public MailBox getMailBox() {
        return this.mailBox;
    }

    @Generated
    public Manage getManage() {
        return this.manage;
    }

    @Generated
    public InvitationRepository getInvitationRepository() {
        return this.invitationRepository;
    }
}

