/*
 * Decompiled with CFR 0.152.
 */
package access.provision.eva;

import access.model.RemoteProvisionedUser;
import access.model.User;
import access.provision.Provisioning;
import access.provision.ProvisioningType;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Comparator;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class GuestAccount {
    private static final String EVA_DATE_PATTERN = "yyyy-MM-dd";
    private final MultiValueMap<String, String> request;

    public GuestAccount(User user, Provisioning provisioning) {
        assert (provisioning.getProvisioningType().equals((Object)ProvisioningType.eva)) : "Must be eva provisioning";
        Instant now = Instant.now();
        Instant dateTill = user.userRolesForProvisioning(provisioning).stream().map(userRole -> userRole.getEndDate()).max(Comparator.naturalOrder()).orElseThrow(() -> new AssertionError((Object)("No userRoles found for provisioning:" + provisioning.getEntityId())));
        String language = LocaleContextHolder.getLocale().getLanguage();
        this.request = new LinkedMultiValueMap();
        this.request.add((Object)"name", (Object)user.getName());
        this.request.add((Object)"email", (Object)user.getEmail());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(EVA_DATE_PATTERN);
        this.request.add((Object)"dateFrom", (Object)simpleDateFormat.format(Date.from(now)));
        this.request.add((Object)"dateTill", (Object)simpleDateFormat.format(Date.from(dateTill)));
        this.request.add((Object)"notifyByEmail", (Object)Boolean.TRUE.toString());
        this.request.add((Object)"notifyBySms", (Object)Boolean.FALSE.toString());
        this.request.add((Object)"preferredLanguage", (Object)language);
    }

    public static String dateFrom(RemoteProvisionedUser remoteProvisionedUser) {
        return new SimpleDateFormat(EVA_DATE_PATTERN).format(Date.from(remoteProvisionedUser.getCreatedAt()));
    }

    public MultiValueMap<String, String> getRequest() {
        return this.request;
    }
}

