/*
 * Decompiled with CFR 0.152.
 */
package access.security;

import access.exception.UserRestrictionException;
import access.model.Authority;
import access.model.Role;
import access.model.User;
import access.model.UserRole;
import java.util.List;
import java.util.Set;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class UserPermissions {
    private UserPermissions() {
    }

    public static void assertSuperUser(User user) {
        if (user == null) {
            throw new UserRestrictionException();
        }
        if (!user.isSuperUser()) {
            throw new UserRestrictionException();
        }
    }

    public static void assertInstitutionAdmin(User user) {
        if (user == null) {
            throw new UserRestrictionException();
        }
        if (user.isSuperUser() || user.isInstitutionAdmin() && StringUtils.hasText((String)user.getOrganizationGUID())) {
            return;
        }
        throw new UserRestrictionException();
    }

    public static void assertAuthority(User user, Authority authority) {
        if (user == null) {
            throw new UserRestrictionException();
        }
        if (user.isInstitutionAdmin() && Authority.INSTITUTION_ADMIN.hasEqualOrHigherRights(authority)) {
            return;
        }
        if (!user.isSuperUser() && user.getUserRoles().stream().noneMatch(userRole -> userRole.getAuthority().hasEqualOrHigherRights(authority))) {
            throw new UserRestrictionException();
        }
    }

    public static void assertValidInvitation(User user, Authority intendedAuthority, List<Role> roles) {
        if (user == null) {
            throw new UserRestrictionException();
        }
        if (user.isSuperUser()) {
            return;
        }
        if (intendedAuthority.equals((Object)Authority.SUPER_USER)) {
            throw new UserRestrictionException();
        }
        Set userRoles = user.getUserRoles();
        if (user.isInstitutionAdmin() && roles.stream().allMatch(role -> user.getOrganizationGUID().equals(role.getOrganizationGUID()))) {
            return;
        }
        boolean allowed = roles.stream().allMatch(role -> UserPermissions.mayInviteByApplication((Set)userRoles, (Authority)intendedAuthority, (Role)role) || UserPermissions.mayInviteByAuthority((Set)userRoles, (Authority)intendedAuthority, (Role)role));
        if (!allowed) {
            throw new UserRestrictionException();
        }
    }

    public static void assertRoleAccess(User user, Role accessRole, Authority authority) {
        if (user == null) {
            throw new UserRestrictionException();
        }
        if (user.isSuperUser()) {
            return;
        }
        if (accessRole == null) {
            throw new UserRestrictionException();
        }
        if (user.isInstitutionAdmin() && user.getOrganizationGUID().equals(accessRole.getOrganizationGUID())) {
            return;
        }
        user.getUserRoles().stream().filter(userRole -> userRole.getRole().getId().equals(accessRole.getId()) && userRole.getAuthority().hasEqualOrHigherRights(authority) || userRole.hasAccessToApplication(accessRole) && userRole.getAuthority().hasEqualOrHigherRights(Authority.INSTITUTION_ADMIN)).findFirst().orElseThrow(UserRestrictionException::new);
    }

    private static boolean mayInviteByApplication(Set<UserRole> userRoles, Authority intendedAuthority, Role role) {
        return userRoles.stream().anyMatch(userRole -> userRole.hasAccessToApplication(role) && userRole.getAuthority().hasEqualOrHigherRights(Authority.MANAGER) && userRole.getAuthority().hasEqualOrHigherRights(intendedAuthority));
    }

    private static boolean mayInviteByAuthority(Set<UserRole> userRoles, Authority intendedAuthority, Role role) {
        return userRoles.stream().anyMatch(userRole -> userRole.getAuthority().hasHigherRights(intendedAuthority) && userRole.getAuthority().hasEqualOrHigherRights(Authority.INVITER) && userRole.getRole().getId().equals(role.getId()));
    }
}

