/*
 * Decompiled with CFR 0.152.
 */
package access.seed;

import access.api.APITokenController;
import access.manage.EntityType;
import access.manage.Manage;
import access.manage.ManageIdentifier;
import access.model.Application;
import access.model.ApplicationUsage;
import access.model.Authority;
import access.model.Invitation;
import access.model.InvitationRole;
import access.model.Language;
import access.model.Role;
import access.model.User;
import access.model.UserRole;
import access.repository.ApplicationRepository;
import access.repository.InvitationRepository;
import access.repository.RoleRepository;
import access.repository.UserRepository;
import access.repository.UserRoleRepository;
import access.seed.NameGenerator;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class PerformanceSeed {
    private static final Log LOG = LogFactory.getLog(APITokenController.class);
    private static final Random random = new Random();
    private final UserRepository userRepository;
    private final RoleRepository roleRepository;
    private final ApplicationRepository applicationRepository;
    private final UserRoleRepository userRoleRepository;
    private final InvitationRepository invitationRepository;
    private final Manage manage;

    public PerformanceSeed(UserRepository userRepository, RoleRepository roleRepository, ApplicationRepository applicationRepository, UserRoleRepository userRoleRepository, InvitationRepository invitationRepository, Manage manage, DataSource dataSource) {
        this.userRepository = userRepository;
        this.roleRepository = roleRepository;
        this.applicationRepository = applicationRepository;
        this.userRoleRepository = userRoleRepository;
        this.invitationRepository = invitationRepository;
        this.manage = manage;
    }

    public Map<String, Object> go(int numberOfRoles, int numberOfUsers) {
        List providers = this.manage.providers(new EntityType[]{EntityType.SAML20_SP, EntityType.OIDC10_RP});
        List identityProviders = this.manage.providers(new EntityType[]{EntityType.SAML20_IDP});
        List<String> institutionGuids = identityProviders.stream().map(m -> (String)m.get("institutionGuid")).filter(s -> s != null).toList();
        ArrayList roleIdentifiers = new ArrayList();
        IntStream.range(1, numberOfRoles + 1).forEach(i -> {
            String institutionGuid = (String)institutionGuids.get(random.nextInt(institutionGuids.size()));
            Role role = this.createRole(providers, institutionGuid);
            role = (Role)this.roleRepository.save((Object)role);
            roleIdentifiers.add(role.getId());
            if (i % 100 == 0) {
                LOG.debug((Object)String.format("Created %s from %s roles", i, numberOfRoles));
            }
        });
        IntStream.range(1, numberOfUsers + 1).forEach(i -> {
            String institutionGuid = (String)institutionGuids.get(random.nextInt(institutionGuids.size()));
            User user = (User)this.userRepository.save((Object)this.createUser(institutionGuid));
            long roleId = (Long)roleIdentifiers.get(random.nextInt(roleIdentifiers.size()));
            Optional optionalRole = this.roleRepository.findById((Object)roleId);
            if (optionalRole.isEmpty()) {
                LOG.debug((Object)("Hitting empty role: " + roleId));
            } else {
                Role role = (Role)optionalRole.get();
                if (!user.isInstitutionAdmin()) {
                    this.userRoleRepository.save((Object)this.createUserRole(user, role));
                }
                this.invitationRepository.save((Object)this.createInvitation(user, role));
                if (i % 1000 == 0) {
                    LOG.debug((Object)String.format("Created %s from %s users", i, numberOfUsers));
                }
            }
        });
        return Map.of("users", numberOfUsers, "roles", numberOfRoles, "userRoles", numberOfUsers);
    }

    private User createUser(String institutionGuid) {
        String uuid = UUID.randomUUID().toString();
        String givenName = NameGenerator.generate();
        String familyName = "Doe";
        String schacHome = NameGenerator.generate().toLowerCase() + ".org";
        String eppn = String.format("%s.%s@%s", givenName.toLowerCase(), familyName.toLowerCase(), schacHome);
        User user = new User(false, eppn, uuid, schacHome, givenName, familyName, eppn);
        int i = random.nextInt(15);
        if (i == 9) {
            user.setInstitutionAdmin(true);
            user.setOrganizationGUID(institutionGuid);
        }
        return user;
    }

    private UserRole createUserRole(User user, Role role) {
        Authority authority = PerformanceSeed.getAuthority();
        return new UserRole("performance-seed", user, role, authority);
    }

    private static Authority getAuthority() {
        double randomDouble = Math.random();
        return randomDouble > 0.8 ? Authority.MANAGER : (randomDouble < 0.2 ? Authority.INVITER : Authority.GUEST);
    }

    private Invitation createInvitation(User inviter, Role role) {
        Set<InvitationRole> roles = Set.of(new InvitationRole(role));
        return new Invitation(PerformanceSeed.getAuthority(), UUID.randomUUID().toString(), String.format("%s@example.com", NameGenerator.generate()), false, false, false, "Auto generated", Language.en, inviter, Instant.now().plus(30L, ChronoUnit.DAYS), Instant.now().plus(1825L, ChronoUnit.DAYS), roles);
    }

    private Role createRole(List<Map<String, Object>> providers, String institutionGuid) {
        String name = NameGenerator.generate();
        int i = random.nextInt(1, 15);
        int numberOfApplications = i > 13 ? 1 : i;
        Set manageIdentifiers = IntStream.range(0, numberOfApplications).mapToObj(j -> {
            Map provider = (Map)providers.get(random.nextInt(providers.size()));
            return new ManageIdentifier((String)provider.get("id"), EntityType.valueOf((String)((String)provider.get("type")).toUpperCase()));
        }).collect(Collectors.toSet());
        Set applicationUsages = manageIdentifiers.stream().map(manageIdentifier -> new ApplicationUsage(this.application(manageIdentifier), "http://landingpage.com")).collect(Collectors.toSet());
        Role role = new Role(name, name, applicationUsages, Integer.valueOf(1825), false, false);
        role.setOrganizationGUID(institutionGuid);
        return role;
    }

    private Application application(ManageIdentifier manageIdentifier) {
        String manageId = manageIdentifier.manageId();
        EntityType entityType = manageIdentifier.manageType();
        return this.applicationRepository.findByManageIdAndManageType(manageId, entityType).orElseGet(() -> (Application)this.applicationRepository.save((Object)new Application(manageId, entityType)));
    }
}

