/*
 * Decompiled with CFR 0.152.
 */
package access.api;

import access.api.FullSearchQueryParser;
import access.api.Results;
import access.api.UserRoleOperations;
import access.api.UserRoleResource;
import access.config.Config;
import access.exception.NotAllowedException;
import access.exception.NotFoundException;
import access.logging.AccessLogger;
import access.logging.Event;
import access.model.Authority;
import access.model.Role;
import access.model.UpdateUserRole;
import access.model.User;
import access.model.UserRole;
import access.model.UserRoleProvisioning;
import access.provision.ProvisioningService;
import access.provision.scim.OperationType;
import access.repository.RoleRepository;
import access.repository.UserRepository;
import access.repository.UserRoleRepository;
import access.security.UserPermissions;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.security.SecurityRequirements;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/user_roles", "/api/external/v1/user_roles"}, produces={"application/json"})
@Transactional
@SecurityRequirements(value={@SecurityRequirement(name="openId", scopes={"openid"}), @SecurityRequirement(name="apiTokens")})
@EnableConfigurationProperties(value={Config.class})
public class UserRoleController
implements UserRoleResource {
    private static final Log LOG = LogFactory.getLog(UserRoleController.class);
    private final UserRoleRepository userRoleRepository;
    private final RoleRepository roleRepository;
    private final UserRepository userRepository;
    private final ProvisioningService provisioningService;
    private final Config config;
    private final UserRoleOperations userRoleOperations;

    public UserRoleController(UserRoleRepository userRoleRepository, RoleRepository roleRepository, UserRepository userRepository, ProvisioningService provisioningService, Config config) {
        this.userRoleRepository = userRoleRepository;
        this.roleRepository = roleRepository;
        this.userRepository = userRepository;
        this.provisioningService = provisioningService;
        this.config = config;
        this.userRoleOperations = new UserRoleOperations((UserRoleResource)this);
    }

    @GetMapping(value={"roles/{roleId}"})
    public ResponseEntity<List<UserRole>> byRole(@PathVariable(value="roleId") Long roleId, @Parameter(hidden=true) User user) {
        return this.userRoleOperations.userRolesByRole(roleId, role -> UserPermissions.assertRoleAccess((User)user, (Role)role, (Authority)Authority.INVITER));
    }

    @GetMapping(value={"managers/{roleId}"})
    public ResponseEntity<List<String>> managersByRole(@PathVariable(value="roleId") Long roleId, @Parameter(hidden=true) User user) {
        Role role = (Role)this.roleRepository.findById((Object)roleId).orElseThrow(() -> new NotFoundException("Role not found"));
        UserPermissions.assertRoleAccess((User)user, (Role)role, (Authority)Authority.INVITER);
        List userRoles = this.userRoleRepository.findByRoleAndAuthorityIn(role, List.of(Authority.MANAGER, Authority.INSTITUTION_ADMIN));
        return ResponseEntity.ok(userRoles.stream().map(userRole -> userRole.getUser().getEmail()).toList());
    }

    @GetMapping(value={"/consequences/{roleId}"})
    public ResponseEntity<List<Map<String, Object>>> consequencesDeleteRole(@PathVariable(value="roleId") Long roleId, @Parameter(hidden=true) User user) {
        Role role = (Role)this.roleRepository.findById((Object)roleId).orElseThrow(() -> new NotFoundException("Role not found"));
        LOG.debug((Object)String.format("Fetching consequences delete role %s by user %s", role.getName(), user.getEduPersonPrincipalName()));
        UserPermissions.assertRoleAccess((User)user, (Role)role, (Authority)Authority.INSTITUTION_ADMIN);
        List userRoles = this.userRoleRepository.findByRole(role);
        List<Map> res = userRoles.stream().map(userRole -> Map.of("authority", userRole.getAuthority().name(), "userInfo", userRole.getUser().asMap())).toList();
        return ResponseEntity.ok(res);
    }

    @GetMapping(value={"/search/{roleId}/{guests}"})
    public ResponseEntity<Page<?>> searchPaginated(@PathVariable(value="roleId") Long roleId, @PathVariable(value="guests") boolean guests, @RequestParam(value="query", required=false, defaultValue="") String query, @RequestParam(value="pageNumber", required=false, defaultValue="0") int pageNumber, @RequestParam(value="pageSize", required=false, defaultValue="10") int pageSize, @RequestParam(value="sort", required=false, defaultValue="name") String sort, @RequestParam(value="sortDirection", required=false, defaultValue="ASC") String sortDirection, @Parameter(hidden=true) User user) {
        Page page;
        LOG.debug((Object)String.format("/search for user %s", user.getEduPersonPrincipalName()));
        Role role = (Role)this.roleRepository.findById((Object)roleId).orElseThrow(() -> new NotFoundException("Role not found"));
        UserPermissions.assertRoleAccess((User)user, (Role)role, (Authority)Authority.INVITER);
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)pageSize, (Sort)Sort.by((Sort.Direction)Sort.Direction.fromString((String)sortDirection), (String[])new String[]{sort}));
        if (StringUtils.hasText((String)query)) {
            query = FullSearchQueryParser.parse((String)query);
            page = guests ? this.userRoleRepository.searchGuestsByPageWithKeyword(roleId, query, (Pageable)pageable) : this.userRoleRepository.searchNonGuestsByPageWithKeyword(roleId, query, (Pageable)pageable);
        } else {
            page = guests ? this.userRoleRepository.searchGuestsByPage(roleId, (Pageable)pageable) : this.userRoleRepository.searchNonGuestsByPage(roleId, (Pageable)pageable);
        }
        return ResponseEntity.ok((Object)page);
    }

    @PostMapping(value={"user_role_provisioning"})
    @Operation(summary="Add Role to a User", description="Provision the User if the User is unknown and add the Role(s)")
    public ResponseEntity<User> userRoleProvisioning(@Validated @RequestBody UserRoleProvisioning userRoleProvisioning, @Parameter(hidden=true) User apiUser) {
        userRoleProvisioning.validate();
        UserPermissions.assertInstitutionAdmin((User)apiUser);
        List<Role> roles = userRoleProvisioning.roleIdentifiers.stream().map(roleId -> (Role)this.roleRepository.findById(roleId).orElseThrow(() -> new NotFoundException("Role not found"))).toList();
        UserPermissions.assertValidInvitation((User)apiUser, (Authority)userRoleProvisioning.intendedAuthority, roles);
        Optional userOptional = Optional.empty();
        if (StringUtils.hasText((String)userRoleProvisioning.sub)) {
            userOptional = this.userRepository.findBySubIgnoreCase(userRoleProvisioning.sub);
        } else if (StringUtils.hasText((String)userRoleProvisioning.eduPersonPrincipalName)) {
            userOptional = this.userRepository.findByEduPersonPrincipalNameIgnoreCase(userRoleProvisioning.eduPersonPrincipalName);
        } else if (StringUtils.hasText((String)userRoleProvisioning.email)) {
            userOptional = this.userRepository.findByEmailIgnoreCase(userRoleProvisioning.email);
        }
        User user = userOptional.orElseGet(() -> (User)this.userRepository.save((Object)new User(userRoleProvisioning)));
        List<UserRole> newUserRoles = roles.stream().map(role -> user.getUserRoles().stream().noneMatch(userRole -> userRole.getRole().getId().equals(role.getId())) ? user.addUserRole(new UserRole(apiUser.getName(), user, role, userRoleProvisioning.intendedAuthority, userRoleProvisioning.guestRoleIncluded, Instant.now().plus((long)role.getDefaultExpiryDays().intValue(), ChronoUnit.DAYS))) : null).filter(Objects::nonNull).toList();
        this.userRepository.save((Object)user);
        AccessLogger.user((Log)LOG, (Event)Event.Created, (User)user);
        this.provisioningService.newUserRequest(user);
        newUserRoles.forEach(userRole -> this.provisioningService.updateGroupRequest(userRole, OperationType.Add));
        return ResponseEntity.status((int)201).body((Object)user);
    }

    @PutMapping(value={""})
    public ResponseEntity<Map<String, Integer>> updateUserRoleExpirationDate(@Validated @RequestBody UpdateUserRole updateUserRole, @Parameter(hidden=true) User user) {
        UserRole userRole = (UserRole)this.userRoleRepository.findById((Object)updateUserRole.getUserRoleId()).orElseThrow(() -> new NotFoundException("UserRole not found"));
        if (updateUserRole.getEndDate() != null && !this.config.isPastDateAllowed() && Instant.now().isAfter(updateUserRole.getEndDate())) {
            throw new NotAllowedException("End date must be after now");
        }
        UserPermissions.assertValidInvitation((User)user, (Authority)userRole.getAuthority(), List.of(userRole.getRole()));
        userRole.setEndDate(updateUserRole.getEndDate());
        this.userRoleRepository.save((Object)userRole);
        this.provisioningService.updateUserRoleRequest(userRole);
        return Results.createResult();
    }

    @DeleteMapping(value={"/{id}/{isGuest}"})
    public ResponseEntity<Void> deleteUserRole(@PathVariable(value="id") Long id, @PathVariable(value="isGuest") Boolean isGuest, @Parameter(hidden=true) User user) {
        LOG.debug((Object)"/deleteUserRole");
        UserRole userRole = (UserRole)this.userRoleRepository.findById((Object)id).orElseThrow(() -> new NotFoundException("UserRole not found"));
        if (!userRole.getUser().getId().equals(user.getId())) {
            UserPermissions.assertValidInvitation((User)user, (Authority)(isGuest != false ? Authority.GUEST : userRole.getAuthority()), List.of(userRole.getRole()));
        }
        if (userRole.isGuestRoleIncluded()) {
            userRole.setGuestRoleIncluded(false);
            if (!isGuest.booleanValue()) {
                userRole.setAuthority(Authority.GUEST);
            }
            this.userRoleRepository.save((Object)userRole);
            AccessLogger.userRole((Log)LOG, (Event)Event.Updated, (User)user, (UserRole)userRole);
        } else {
            this.provisioningService.updateGroupRequest(userRole, OperationType.Remove);
            this.provisioningService.deleteUserRoleRequest(userRole);
            this.userRoleRepository.deleteUserRoleById(id);
            AccessLogger.userRole((Log)LOG, (Event)Event.Deleted, (User)user, (UserRole)userRole);
        }
        return Results.deleteResult();
    }

    @Generated
    public UserRoleRepository getUserRoleRepository() {
        return this.userRoleRepository;
    }

    @Generated
    public RoleRepository getRoleRepository() {
        return this.roleRepository;
    }
}

