/*
 * Decompiled with CFR 0.152.
 */
package access.provision.scim;

import access.model.User;
import access.provision.Provisioning;
import access.provision.ScimUserIdentifier;
import access.provision.scim.Email;
import access.provision.scim.Name;
import access.provision.scim.UserRequest;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;

public class UserRequest
implements Serializable {
    private static final Log LOG = LogFactory.getLog(UserRequest.class);
    private final List<String> schemas = Collections.singletonList("urn:ietf:params:scim:schemas:core:2.0:User");
    private final String externalId;
    private final String userName;
    private final Name name;
    private String id;
    private final String displayName;
    private final List<Email> emails;

    public UserRequest(User user, Provisioning provisioning) {
        this.externalId = this.resolveExternalId(user, provisioning);
        this.userName = user.getEduPersonPrincipalName();
        this.name = new Name(user.getName(), user.getFamilyName(), user.getGivenName());
        this.displayName = user.getName();
        this.emails = Collections.singletonList(new Email(user.getEmail()));
    }

    public UserRequest(User user, Provisioning provisioning, String remoteScimIdentifier) {
        this(user, provisioning);
        this.id = remoteScimIdentifier;
    }

    private String resolveExternalId(User user, Provisioning provisioning) {
        String externalIdIdentifier;
        ScimUserIdentifier scimUserIdentifier = provisioning.getScimUserIdentifier();
        String defaultExternalId = user.getEduPersonPrincipalName();
        if (scimUserIdentifier == null) {
            return defaultExternalId;
        }
        boolean missingScimUserIdentifierValue = false;
        switch (1.$SwitchMap$access$provision$ScimUserIdentifier[scimUserIdentifier.ordinal()]) {
            case 1: {
                String string;
                boolean bl = missingScimUserIdentifierValue = !StringUtils.hasText((String)user.getSubjectId());
                if (missingScimUserIdentifierValue) {
                    string = defaultExternalId;
                    break;
                }
                string = user.getSubjectId();
                break;
            }
            case 2: {
                String string;
                boolean bl = missingScimUserIdentifierValue = !StringUtils.hasText((String)user.getUid());
                if (missingScimUserIdentifierValue) {
                    string = defaultExternalId;
                    break;
                }
                string = user.getUid();
                break;
            }
            case 3: {
                String string;
                boolean bl = missingScimUserIdentifierValue = !StringUtils.hasText((String)user.getEmail());
                if (missingScimUserIdentifierValue) {
                    string = defaultExternalId;
                    break;
                }
                string = user.getEmail();
                break;
            }
            case 4: {
                String string;
                boolean bl = missingScimUserIdentifierValue = !StringUtils.hasText((String)user.getEduId());
                if (missingScimUserIdentifierValue) {
                    string = defaultExternalId;
                    break;
                }
                string = user.getEduId();
                break;
            }
            default: {
                String string = externalIdIdentifier = defaultExternalId;
            }
        }
        if (missingScimUserIdentifierValue) {
            LOG.warn((Object)String.format("Missing attribute %s for SCIM provisioning to %s for user %s. Return defaultExternalId %s", scimUserIdentifier, provisioning.getEntityId(), user.getSub(), defaultExternalId));
        }
        return externalIdIdentifier;
    }

    @Generated
    public List<String> getSchemas() {
        return this.schemas;
    }

    @Generated
    public String getExternalId() {
        return this.externalId;
    }

    @Generated
    public String getUserName() {
        return this.userName;
    }

    @Generated
    public Name getName() {
        return this.name;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public List<Email> getEmails() {
        return this.emails;
    }
}

