/*
 * Decompiled with CFR 0.152.
 */
package access.api;

import access.api.InvitationResource;
import access.api.Results;
import access.config.HashGenerator;
import access.exception.NotAllowedException;
import access.exception.NotFoundException;
import access.logging.AccessLogger;
import access.logging.Event;
import access.mail.MailBox;
import access.model.Authority;
import access.model.Invitation;
import access.model.InvitationRequest;
import access.model.InvitationResponse;
import access.model.InvitationRole;
import access.model.Provisionable;
import access.model.RecipientInvitationURL;
import access.model.Role;
import access.model.User;
import access.repository.InvitationRepository;
import access.security.RemoteUser;
import access.security.RemoteUserPermissions;
import access.security.UserPermissions;
import access.validation.EmailFormatValidator;
import java.time.Instant;
import java.time.Period;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.util.CollectionUtils;

public class InvitationOperations {
    private static final Log LOG = LogFactory.getLog(InvitationOperations.class);
    private final EmailFormatValidator emailFormatValidator = new EmailFormatValidator();
    private final InvitationResource invitationResource;

    public InvitationOperations(InvitationResource invitationResource) {
        this.invitationResource = invitationResource;
    }

    public ResponseEntity<InvitationResponse> sendInvitation(InvitationRequest invitationRequest, User user, RemoteUser remoteUser) {
        Authority intendedAuthority = invitationRequest.getIntendedAuthority();
        if (!List.of(Authority.INSTITUTION_ADMIN, Authority.SUPER_USER).contains(intendedAuthority) && CollectionUtils.isEmpty((Collection)invitationRequest.getRoleIdentifiers())) {
            throw new NotAllowedException("Invitation for non-super-user or institution-admin must contain at least one role");
        }
        List<Role> requestedRoles = invitationRequest.getRoleIdentifiers().stream().map(id -> (Role)this.invitationResource.getRoleRepository().findById(id).orElseThrow(() -> new NotFoundException("Role not found"))).toList();
        if (user != null) {
            UserPermissions.assertValidInvitation((User)user, (Authority)intendedAuthority, requestedRoles);
        } else {
            RemoteUserPermissions.assertApplicationAccess((RemoteUser)remoteUser, requestedRoles);
        }
        boolean isOverrideSettingsAllowed = requestedRoles.stream().allMatch(Role::isOverrideSettingsAllowed);
        if (!isOverrideSettingsAllowed) {
            invitationRequest.setEduIDOnly(requestedRoles.stream().anyMatch(Role::isEduIDOnly));
            invitationRequest.setEnforceEmailEquality(requestedRoles.stream().anyMatch(Role::isEnforceEmailEquality));
            if (intendedAuthority.equals((Object)Authority.GUEST)) {
                Integer defaultExpiryDays = requestedRoles.stream().max(Comparator.comparingInt(Role::getDefaultExpiryDays)).get().getDefaultExpiryDays();
                invitationRequest.setRoleExpiryDate(Instant.now().plus((long)defaultExpiryDays.intValue(), ChronoUnit.DAYS));
            }
        }
        List<Invitation> invitations = invitationRequest.getInvites().stream().filter(email -> {
            boolean valid = this.emailFormatValidator.isValid(email);
            if (!valid) {
                LOG.debug((Object)("Not sending invalid email for invitation: " + email));
            }
            return valid;
        }).map(invitee -> new Invitation(intendedAuthority, HashGenerator.generateRandomHash(), invitee, invitationRequest.isEnforceEmailEquality(), invitationRequest.isEduIDOnly(), invitationRequest.isGuestRoleIncluded(), invitationRequest.getMessage(), invitationRequest.getLanguage(), user, invitationRequest.getExpiryDate(), invitationRequest.getRoleExpiryDate(), requestedRoles.stream().map(InvitationRole::new).collect(Collectors.toSet()))).toList();
        if (user == null) {
            invitations.forEach(invitation -> invitation.setRemoteApiUser(remoteUser.getName()));
        }
        this.invitationResource.getInvitationRepository().saveAll(invitations);
        List groupedProviders = this.invitationResource.getManage().getGroupedProviders(requestedRoles);
        MailBox mailBox = this.invitationResource.getMailBox();
        List<RecipientInvitationURL> recipientInvitationURLs = invitations.stream().map(invitation -> new RecipientInvitationURL(invitation.getEmail(), mailBox.inviteMailURL(invitation))).toList();
        if (!invitationRequest.isSuppressSendingEmails()) {
            invitations.forEach(invitation -> mailBox.sendInviteMail((Provisionable)(user == null ? remoteUser : user), invitation, groupedProviders, invitationRequest.getLanguage()));
        }
        invitations.forEach(invitation -> AccessLogger.invitation((Log)LOG, (Event)Event.Created, (Invitation)invitation));
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)new InvitationResponse(HttpStatus.CREATED.value(), recipientInvitationURLs));
    }

    public ResponseEntity<Map<String, Integer>> resendInvitation(Long id, User user, RemoteUser remoteUser) {
        String name = user != null ? user.getEduPersonPrincipalName() : remoteUser.getDisplayName();
        LOG.debug((Object)String.format("/resendInvitation/%s by user %s", id, name));
        InvitationRepository invitationRepository = this.invitationResource.getInvitationRepository();
        Invitation invitation = (Invitation)invitationRepository.findById((Object)id).orElseThrow(() -> new NotFoundException("Invitation not found"));
        List<Role> requestedRoles = invitation.getRoles().stream().map(InvitationRole::getRole).toList();
        Authority intendedAuthority = invitation.getIntendedAuthority();
        if (user != null) {
            UserPermissions.assertValidInvitation((User)user, (Authority)intendedAuthority, requestedRoles);
        } else {
            RemoteUserPermissions.assertApplicationAccess((RemoteUser)remoteUser, requestedRoles);
        }
        List groupedProviders = this.invitationResource.getManage().getGroupedProviders(requestedRoles);
        User provisionable = user != null ? user : remoteUser;
        this.invitationResource.getMailBox().sendInviteMail((Provisionable)provisionable, invitation, groupedProviders, invitation.getLanguage());
        if (invitation.getExpiryDate().isBefore(Instant.now())) {
            invitation.setExpiryDate(Instant.now().plus(Period.ofDays(14)));
            invitationRepository.save((Object)invitation);
        }
        AccessLogger.invitation((Log)LOG, (Event)Event.Resend, (Invitation)invitation);
        return Results.createResult();
    }
}

