/*
 * Decompiled with CFR 0.152.
 */
package access.cron;

import access.mail.MailBox;
import access.manage.Manage;
import access.model.GroupedProviders;
import access.repository.UserRoleRepository;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class RoleExpirationNotifier {
    private static final Log LOG = LogFactory.getLog(RoleExpirationNotifier.class);
    private final UserRoleRepository userRoleRepository;
    private final Manage manage;
    private final MailBox mailBox;
    private final boolean cronJobResponsible;
    private final int roleExpirationNotificationDays;

    public RoleExpirationNotifier(UserRoleRepository userRoleRepository, Manage manage, MailBox mailBox, @Value(value="${cron.node-cron-job-responsible}") boolean cronJobResponsible, @Value(value="${cron.role-expiration-notifier-duration-days}") int roleExpirationNotificationDays) {
        this.userRoleRepository = userRoleRepository;
        this.manage = manage;
        this.mailBox = mailBox;
        this.cronJobResponsible = cronJobResponsible;
        this.roleExpirationNotificationDays = roleExpirationNotificationDays;
    }

    @Scheduled(cron="${cron.role-expiration-notifier-expression}")
    @Transactional
    public void sweep() {
        if (!this.cronJobResponsible || this.roleExpirationNotificationDays == -1) {
            return;
        }
        Instant instant = Instant.now().plus((long)this.roleExpirationNotificationDays, ChronoUnit.DAYS);
        List userRoles = this.userRoleRepository.findByEndDateBeforeAndExpiryNotifications(instant, Integer.valueOf(0));
        userRoles.forEach(userRole -> {
            List groupedProviders = this.manage.getGroupedProviders(List.of(userRole.getRole()));
            GroupedProviders groupedProvider = groupedProviders.isEmpty() ? null : (GroupedProviders)groupedProviders.get(0);
            this.mailBox.sendUserRoleExpirationNotificationMail(userRole, groupedProvider, this.roleExpirationNotificationDays);
            userRole.setExpiryNotifications(1);
            this.userRoleRepository.save(userRole);
            LOG.info((Object)("Send expiration notification mail to " + userRole.getUser().getEmail()));
        });
    }

    public Manage getManage() {
        return this.manage;
    }
}

