/*
 * Decompiled with CFR 0.152.
 */
package access.model;

import access.model.Authority;
import com.fasterxml.jackson.annotation.JsonIgnore;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import org.springframework.util.StringUtils;

public class UserRoleProvisioning {
    @NotEmpty
    public List<Long> roleIdentifiers;
    public Authority intendedAuthority = Authority.GUEST;
    public String sub;
    @NotNull
    public String email;
    public String eduPersonPrincipalName;
    public String givenName;
    public String familyName;
    public String name;
    public String schacHomeOrganization;
    public boolean guestRoleIncluded;

    public void validate() {
        if (!(StringUtils.hasText((String)this.email) || StringUtils.hasText((String)this.eduPersonPrincipalName) && this.eduPersonPrincipalName.contains("@"))) {
            throw new IllegalArgumentException("Requires one off: email, eduPersonPrincipalName. Invalid userRoleProvisioning: " + this);
        }
    }

    @JsonIgnore
    public String resolveSub() {
        String mail;
        String eppn;
        if (StringUtils.hasText((String)this.sub)) {
            return this.sub;
        }
        String schacHome = null;
        String uid = null;
        if (StringUtils.hasText((String)this.schacHomeOrganization)) {
            schacHome = this.schacHomeOrganization;
        }
        if (StringUtils.hasText((String)(eppn = this.eduPersonPrincipalName)) && eppn.contains("@")) {
            uid = eppn.substring(0, eppn.indexOf("@"));
            String string = schacHome = schacHome != null ? schacHome : eppn.substring(eppn.indexOf("@") + 1);
        }
        if (StringUtils.hasText((String)(mail = this.email))) {
            uid = uid != null ? uid : mail.substring(0, mail.indexOf("@"));
            String string = schacHome = schacHome != null ? schacHome : mail.substring(mail.indexOf("@") + 1);
        }
        if (schacHome == null || uid == null) {
            throw new IllegalArgumentException("Can't resolve sub from " + this);
        }
        if (!StringUtils.hasText((String)this.schacHomeOrganization) && StringUtils.hasText((String)schacHome)) {
            this.schacHomeOrganization = schacHome;
        }
        return String.format("urn:collab:person:%s:%s", schacHome, uid);
    }

    public String toString() {
        return "UserRoleProvisioning(roleIdentifiers=" + this.roleIdentifiers + ", intendedAuthority=" + this.intendedAuthority + ", sub=" + this.sub + ", email=" + this.email + ", eduPersonPrincipalName=" + this.eduPersonPrincipalName + ", givenName=" + this.givenName + ", familyName=" + this.familyName + ", name=" + this.name + ", schacHomeOrganization=" + this.schacHomeOrganization + ", guestRoleIncluded=" + this.guestRoleIncluded + ")";
    }

    public UserRoleProvisioning(List<Long> roleIdentifiers, Authority intendedAuthority, String sub, String email, String eduPersonPrincipalName, String givenName, String familyName, String name, String schacHomeOrganization, boolean guestRoleIncluded) {
        this.roleIdentifiers = roleIdentifiers;
        this.intendedAuthority = intendedAuthority;
        this.sub = sub;
        this.email = email;
        this.eduPersonPrincipalName = eduPersonPrincipalName;
        this.givenName = givenName;
        this.familyName = familyName;
        this.name = name;
        this.schacHomeOrganization = schacHomeOrganization;
        this.guestRoleIncluded = guestRoleIncluded;
    }

    public UserRoleProvisioning() {
    }
}

