/*
 * Decompiled with CFR 0.152.
 */
package access.repository;

import access.model.User;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

@Repository
public interface UserRepository
extends JpaRepository<User, Long> {
    public Optional<User> findBySubIgnoreCase(String var1);

    public List<User> findByOrganizationGUIDAndInstitutionAdmin(String var1, boolean var2);

    public Optional<User> findByEduPersonPrincipalNameIgnoreCase(String var1);

    public Optional<User> findByEmailIgnoreCase(String var1);

    public List<User> findByLastActivityBefore(Instant var1);

    @Query(value="SELECT * FROM users WHERE MATCH (given_name, family_name, email) against (?1  IN BOOLEAN MODE) AND id > 0 LIMIT ?2", nativeQuery=true)
    public List<User> search(String var1, int var2);

    @Query(value="SELECT * FROM users u WHERE super_user = 0 AND institution_admin = 0 AND NOT EXISTS (SELECT ur.id FROM user_roles ur WHERE ur.user_id = u.id)", nativeQuery=true)
    public List<User> findNonSuperUserWithoutUserRoles();
}

