/*
 * Decompiled with CFR 0.152.
 */
package access.security;

import access.manage.Manage;
import access.model.User;
import access.repository.UserRepository;
import access.security.InstitutionAdmin;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserRequest;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserService;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserService;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.oidc.OidcUserInfo;
import org.springframework.security.oauth2.core.oidc.user.DefaultOidcUser;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;
import org.springframework.util.StringUtils;

public class CustomOidcUserService
implements OAuth2UserService<OidcUserRequest, OidcUser> {
    private final Manage manage;
    private final UserRepository userRepository;
    private final String entitlement;
    private final String organizationGuidPrefix;
    private final OidcUserService delegate;

    public CustomOidcUserService(Manage manage, UserRepository userRepository, String entitlement, String organizationGuidPrefix) {
        this.manage = manage;
        this.userRepository = userRepository;
        this.entitlement = entitlement;
        this.organizationGuidPrefix = organizationGuidPrefix;
        this.delegate = new OidcUserService();
    }

    public OidcUser loadUser(OidcUserRequest userRequest) throws OAuth2AuthenticationException {
        OidcUser oidcUser = this.delegate.loadUser(userRequest);
        Map claims = oidcUser.getUserInfo().getClaims();
        HashMap<String, Object> newClaims = new HashMap<String, Object>(claims);
        String sub = (String)newClaims.get("sub");
        Optional optionalUser = this.userRepository.findBySubIgnoreCase(sub);
        boolean institutionAdmin = InstitutionAdmin.isInstitutionAdmin((Map)claims, (String)this.entitlement) || optionalUser.isPresent() && InstitutionAdmin.isInstitutionAdmin((User)((User)optionalUser.get()));
        newClaims.put("INSTITUTION_ADMIN", institutionAdmin);
        String organizationGuid = institutionAdmin ? (String)InstitutionAdmin.getOrganizationGuid((Map)claims, (String)this.organizationGuidPrefix, (Optional)optionalUser).orElse(null) : null;
        newClaims.put("ORGANIZATION_GUID", organizationGuid);
        if (institutionAdmin && StringUtils.hasText((String)organizationGuid)) {
            Map manageClaims = this.manage.enrichInstitutionAdmin(organizationGuid);
            newClaims.putAll(manageClaims);
        }
        optionalUser.ifPresent(user -> {
            user.updateAttributes(newClaims);
            this.userRepository.save(user);
        });
        OidcUserInfo oidcUserInfo = new OidcUserInfo(newClaims);
        oidcUser = new DefaultOidcUser(oidcUser.getAuthorities(), oidcUser.getIdToken(), oidcUserInfo);
        return oidcUser;
    }

    public Manage getManage() {
        return this.manage;
    }
}

