/*
 * Decompiled with CFR 0.152.
 */
package access.mail;

import access.cron.IdPMetaDataResolver;
import access.mail.MailBox;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.mail.internet.MimeMessage;
import java.io.File;
import java.io.IOException;
import org.springframework.core.env.Environment;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.util.FileCopyUtils;

public class MockMailBox
extends MailBox {
    private final Environment environment;

    public MockMailBox(ObjectMapper objectMapper, IdPMetaDataResolver idPMetaDataResolver, JavaMailSender mailSender, String emailFrom, String contactEmail, String baseUrl, String welcomeUrl, Environment environment) throws IOException {
        super(objectMapper, idPMetaDataResolver, mailSender, emailFrom, contactEmail, baseUrl, welcomeUrl, "local");
        this.environment = environment;
    }

    protected void doSendMail(MimeMessage message) {
    }

    protected void setText(String plainText, String htmlText, MimeMessageHelper helper) throws IOException {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.contains("mac os x") && !this.environment.matchesProfiles(new String[]{"test"})) {
            this.openInBrowser(htmlText);
        }
    }

    private void openInBrowser(String html) throws IOException {
        File tempFile = File.createTempFile("javamail", ".html");
        FileCopyUtils.copy((byte[])html.getBytes(), (File)tempFile);
        String absolutePath = tempFile.getAbsolutePath();
        new ProcessBuilder("open", absolutePath).start();
    }
}

