/*
 * Decompiled with CFR 0.152.
 */
package aa.aggregators.sab;

import aa.aggregators.AbstractAttributeAggregator;
import aa.aggregators.sab.SabResponseParser;
import aa.model.AttributeAuthorityConfiguration;
import aa.model.UserAttribute;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.io.IOUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.springframework.core.io.ClassPathResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;

public class SabAttributeAggregator
extends AbstractAttributeAggregator {
    private static final DateTimeFormatter dateTimeFormatter = ISODateTimeFormat.dateTimeNoMillis().withZone(DateTimeZone.UTC);
    private final String template;
    private final SabResponseParser parser = new SabResponseParser();

    public SabAttributeAggregator(AttributeAuthorityConfiguration attributeAuthorityConfiguration) {
        super(attributeAuthorityConfiguration);
        try {
            this.template = IOUtils.toString((InputStream)new ClassPathResource("sab/request.xml").getInputStream(), (Charset)Charset.defaultCharset());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List<UserAttribute> aggregate(List<UserAttribute> input) {
        List roles;
        String userId = this.getUserAttributeSingleValue(input, "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified");
        String request = this.request(userId);
        ResponseEntity response = this.getRestTemplate().exchange(this.endpoint(), HttpMethod.POST, new HttpEntity((Object)request), String.class);
        try {
            roles = this.parser.parse((Reader)new StringReader((String)response.getBody()));
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
        this.LOG.debug("Retrieved SAB roles with request: {} and response: {}", (Object)request, (Object)response);
        List scopedRoles = roles.stream().map("urn:mace:surfnet.nl:surfnet.nl:sab:role:"::concat).collect(Collectors.toList());
        return this.mapValuesToUserAttribute("urn:mace:dir:attribute-def:eduPersonEntitlement", scopedRoles);
    }

    private String request(String userId) {
        String issueInstant = dateTimeFormatter.print(System.currentTimeMillis());
        return MessageFormat.format(this.template, UUID.randomUUID().toString(), issueInstant, userId);
    }
}

