/*
 * Decompiled with CFR 0.152.
 */
package aa.aggregators.orcid;

import aa.aggregators.AbstractAttributeAggregator;
import aa.model.AccountType;
import aa.model.AttributeAuthorityConfiguration;
import aa.model.UserAttribute;
import aa.repository.AccountRepository;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class OrcidAttributeAggregator
extends AbstractAttributeAggregator {
    private AccountRepository accountRepository;

    public OrcidAttributeAggregator(AttributeAuthorityConfiguration attributeAuthorityConfiguration, AccountRepository accountRepository) {
        super(attributeAuthorityConfiguration);
        this.accountRepository = accountRepository;
    }

    public List<UserAttribute> aggregate(List<UserAttribute> input) {
        String urn = this.getUserAttributeSingleValue(input, "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified");
        Optional accountOptional = this.accountRepository.findByUrnIgnoreCaseAndAccountType(urn, AccountType.ORCID);
        this.LOG.debug("Retrieved ORCID for urn: {} and result {}", (Object)urn, (Object)accountOptional);
        List orcids = accountOptional.map(account -> Collections.singletonList(account.getLinkedId())).orElse(Collections.emptyList());
        return this.mapValuesToUserAttribute("urn:mace:dir:attribute-def:eduPersonOrcid", orcids);
    }
}

