/*
 * Decompiled with CFR 0.152.
 */
package aa.aggregators.voot;

import aa.aggregators.AbstractAttributeAggregator;
import aa.model.AttributeAuthorityConfiguration;
import aa.model.UserAttribute;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.security.oauth2.client.OAuth2RestTemplate;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.client.token.grant.client.ClientCredentialsResourceDetails;

public class VootAttributeAggregator
extends AbstractAttributeAggregator {
    private final OAuth2RestTemplate vootService;

    public VootAttributeAggregator(AttributeAuthorityConfiguration attributeAuthorityConfiguration, String authorizationAccessTokenUrl) {
        super(attributeAuthorityConfiguration);
        this.vootService = this.vootRestTemplate(attributeAuthorityConfiguration, authorizationAccessTokenUrl);
    }

    public List<UserAttribute> aggregate(List<UserAttribute> input) {
        String userId = this.getUserAttributeSingleValue(input, "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified");
        String url = this.endpoint() + "/internal/groups/{userUrn}";
        List listOfGroupMaps = (List)this.vootService.getForObject(url, List.class, new Object[]{userId});
        List groups = listOfGroupMaps.stream().map(entry -> (String)entry.get("id")).collect(Collectors.toList());
        this.LOG.debug("Retrieved VOOT groups with request: {} and response: {}", (Object)url, groups);
        return this.mapValuesToUserAttribute("urn:mace:dir:attribute-def:isMemberOf", groups);
    }

    private OAuth2RestTemplate vootRestTemplate(AttributeAuthorityConfiguration configuration, String authorizationAccessTokenUrl) {
        ClientCredentialsResourceDetails details = new ClientCredentialsResourceDetails();
        details.setId("aa");
        details.setClientId(configuration.getUser());
        details.setClientSecret(configuration.getPassword());
        details.setAccessTokenUri(authorizationAccessTokenUrl);
        details.setScope(Collections.singletonList("groups"));
        return new OAuth2RestTemplate((OAuth2ProtectedResourceDetails)details);
    }
}

