/*
 * Decompiled with CFR 0.152.
 */
package aa.aggregators.sbs;

import aa.aggregators.AbstractAttributeAggregator;
import aa.aggregators.sbs.NotFoundResponseErrorHandler;
import aa.model.AttributeAuthorityConfiguration;
import aa.model.UserAttribute;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.client.ResponseErrorHandler;

public class SBSAttributeAggregator
extends AbstractAttributeAggregator {
    public SBSAttributeAggregator(AttributeAuthorityConfiguration attributeAuthorityConfiguration) {
        super(attributeAuthorityConfiguration);
        this.getRestTemplate().setErrorHandler((ResponseErrorHandler)new NotFoundResponseErrorHandler());
    }

    public List<UserAttribute> aggregate(List<UserAttribute> input) {
        String eduPersonPrincipalName = this.getUserAttributeSingleValue(input, "urn:mace:dir:attribute-def:eduPersonPrincipalName");
        Optional<UserAttribute> emailUserAttribute = input.stream().filter(attr -> attr.getName().equals("urn:mace:dir:attribute-def:mail")).findFirst();
        StringBuilder endpoint = new StringBuilder(this.getAttributeAuthorityConfiguration().getEndpoint().concat("?edu_person_principal_name=").concat(eduPersonPrincipalName));
        emailUserAttribute.ifPresent(userAttribute -> {
            String s;
            List values = userAttribute.getValues();
            if (!CollectionUtils.isEmpty((Collection)values) && StringUtils.hasText((String)(s = (String)values.get(0)))) {
                endpoint.append("&email=").append(this.encode(s));
            }
        });
        List memberShips = (List)this.getRestTemplate().getForEntity(endpoint.toString(), List.class, new Object[0]).getBody();
        this.LOG.debug("Retrieved SBS groups with request: {} and response: {}", (Object)endpoint, (Object)memberShips);
        return this.mapValuesToUserAttribute("urn:mace:dir:attribute-def:isMemberOf", memberShips);
    }
}

