/*
 * Decompiled with CFR 0.152.
 */
package aa.aggregators.entitlements;

import aa.aggregators.AbstractAttributeAggregator;
import aa.model.AttributeAuthorityConfiguration;
import aa.model.UserAttribute;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;

public class EntitlementsAggregator
extends AbstractAttributeAggregator {
    private String token;

    public EntitlementsAggregator(AttributeAuthorityConfiguration configuration) {
        super(configuration);
    }

    protected RestTemplate initializeRestTemplate(AttributeAuthorityConfiguration attributeAuthorityConfiguration) {
        int timeOut = attributeAuthorityConfiguration.getTimeOut();
        HttpComponentsClientHttpRequestFactory httpRequestFactory = new HttpComponentsClientHttpRequestFactory();
        httpRequestFactory.setConnectionRequestTimeout(timeOut);
        httpRequestFactory.setConnectTimeout(timeOut);
        httpRequestFactory.setReadTimeout(timeOut);
        RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)httpRequestFactory);
        return restTemplate;
    }

    public List<UserAttribute> aggregate(List<UserAttribute> input) {
        return this.doAggregate(input, true);
    }

    private List<UserAttribute> doAggregate(List<UserAttribute> input, boolean retryBadToken) {
        String eduPersonPrincipalName = this.getUserAttributeSingleValue(input, "urn:mace:dir:attribute-def:eduPersonPrincipalName");
        String schacHomeOrganization = this.getUserAttributeSingleValue(input, "urn:mace:terena.org:attribute-def:schacHomeOrganization");
        String uid = this.getUserAttributeSingleValue(input, "urn:mace:dir:attribute-def:uid");
        AttributeAuthorityConfiguration configuration = super.getAttributeAuthorityConfiguration();
        if (StringUtils.isEmpty((Object)this.token)) {
            this.token = this.obtainToken();
        }
        HttpHeaders headers = new HttpHeaders();
        headers.add("Authorization", "Bearer".concat(" ").concat(this.token));
        HttpEntity request = new HttpEntity((MultiValueMap)headers);
        String endPoint = configuration.getEndpoint().concat("/api/Entitlement/{eduPersonPrincipalName}/{schacHomeOrganization}/{uid}");
        try {
            ResponseEntity response = this.getRestTemplate().exchange(endPoint, HttpMethod.GET, request, List.class, new Object[]{eduPersonPrincipalName, schacHomeOrganization, uid});
            List body = (List)response.getBody();
            List values = body.stream().map(m -> m.entrySet().stream().findFirst().map(entry -> ((String)entry.getKey()).concat(":").concat((String)entry.getValue()))).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
            return this.mapValuesToUserAttribute("urn:mace:dir:attribute-def:eduPersonEntitlement", values);
        }
        catch (HttpClientErrorException e) {
            if (e.getStatusCode().equals((Object)HttpStatus.UNAUTHORIZED) && retryBadToken) {
                this.token = null;
                return this.doAggregate(input, false);
            }
            throw e;
        }
    }

    private String obtainToken() {
        AttributeAuthorityConfiguration configuration = super.getAttributeAuthorityConfiguration();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.add((Object)"grant_type", (Object)"password");
        map.add((Object)"username", (Object)configuration.getUser());
        map.add((Object)"password", (Object)configuration.getPassword());
        HttpEntity request = new HttpEntity((Object)map, (MultiValueMap)headers);
        ResponseEntity response = this.getRestTemplate().postForEntity(configuration.getEndpoint().concat("/Token"), (Object)request, Map.class, new Object[0]);
        Object accessToken = ((Map)response.getBody()).get("access_token");
        return (String)accessToken;
    }
}

