/*
 * Decompiled with CFR 0.152.
 */
package aa.aggregators.pseudo;

import aa.aggregators.AbstractAttributeAggregator;
import aa.model.AttributeAuthorityConfiguration;
import aa.model.PseudoEmail;
import aa.model.UserAttribute;
import aa.repository.PseudoEmailRepository;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;

public class PseudoEmailAggregator
extends AbstractAttributeAggregator {
    private String emailPostfix;
    private PseudoEmailRepository pseudoEmailRepository;

    public PseudoEmailAggregator(AttributeAuthorityConfiguration configuration, PseudoEmailRepository pseudoEmailRepository, String emailPostfix) {
        super(configuration);
        this.pseudoEmailRepository = pseudoEmailRepository;
        this.emailPostfix = emailPostfix;
    }

    public List<UserAttribute> aggregate(List<UserAttribute> input) {
        String email = this.getUserAttributeSingleValue(input, "urn:mace:dir:attribute-def:mail");
        Optional emailOptional = this.pseudoEmailRepository.findByEmailIgnoreCase(email);
        PseudoEmail pseudoEmail = emailOptional.orElseGet(() -> new PseudoEmail(email, String.format("%s@%s", UUID.randomUUID().toString(), this.emailPostfix)));
        this.LOG.debug("Retrieved Pseudo email for email: {} and result {}", (Object)email, (Object)emailOptional);
        if (pseudoEmail.getId() == null) {
            this.pseudoEmailRepository.save((Object)pseudoEmail);
        }
        return this.mapValuesToUserAttribute("urn:mace:dir:attribute-def:mail", Collections.singletonList(pseudoEmail.getPseudoEmail()));
    }
}

