/*
 * Decompiled with CFR 0.152.
 */
package aa.aggregators.sab;

import aa.aggregators.sab.SabInfoType;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.IntStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class SabResponseParser {
    /*
     * Enabled aggressive block sorting
     */
    public Map<SabInfoType, List<String>> parse(Reader soap) throws XMLStreamException {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        XMLStreamReader reader = factory.createXMLStreamReader(soap);
        HashMap<SabInfoType, List<String>> result = new HashMap<SabInfoType, List<String>>();
        SabInfoType sabInfoType = null;
        List<SabInfoType> sabInfoTypes = Arrays.asList(SabInfoType.values());
        block11: while (reader.hasNext()) {
            switch (reader.next()) {
                case 1: {
                    switch (reader.getLocalName()) {
                        case "Attribute": {
                            Optional<SabInfoType> sabInfoTypeOptional = sabInfoTypes.stream().filter(type -> this.hasAttributeValue(reader, type.getUrn())).findFirst();
                            sabInfoType = sabInfoTypeOptional.orElse(null);
                            break;
                        }
                        case "AttributeValue": {
                            if (sabInfoType == null) break;
                            List subResult = result.computeIfAbsent(sabInfoType, type -> new ArrayList());
                            subResult.add(reader.getElementText().trim());
                        }
                    }
                    continue block11;
                }
            }
        }
        return result;
    }

    private boolean hasAttributeValue(XMLStreamReader reader, String value) {
        return IntStream.range(0, reader.getAttributeCount()).mapToObj(i -> reader.getAttributeValue(i)).anyMatch(v -> v != null && v.equals(value));
    }
}

