/*
 * Decompiled with CFR 0.152.
 */
package aa.control;

import aa.model.Account;
import aa.model.AccountType;
import aa.model.ResourceNotFoundException;
import aa.repository.AccountRepository;
import aa.shibboleth.FederatedUser;
import java.io.IOException;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;

@RestController
public class AccountController {
    private static final Logger LOG = LoggerFactory.getLogger(AccountController.class);
    private static final String CLIENT_REDIRECT_URL = "client_redirect_url";
    @Autowired
    private AccountRepository accountRepository;
    @Value(value="${orcid.authorization_uri}")
    private String orcidAuthorizationUri;
    @Value(value="${orcid.access_token_uri}")
    private String orcidAccessTokenUri;
    @Value(value="${orcid.client_id}")
    private String orcidClientId;
    @Value(value="${orcid.client_secret}")
    private String orcidClientSecret;
    @Value(value="${orcid.redirect_uri}")
    private String orcidRedirectUri;
    private RestTemplate restTemplate = new RestTemplate();
    private HttpHeaders httpHeaders = new HttpHeaders();

    public AccountController() {
        this.httpHeaders.add("Accept", "application/json");
    }

    @GetMapping(value={"/client/connect"})
    public void connect(HttpServletRequest request, HttpServletResponse response, FederatedUser federatedUser, @RequestParam(value="redirectUrl") String redirectUrl) throws IOException {
        LOG.debug("Starting ORCID connection linking for {} with redirect {}", (Object)federatedUser.uid, (Object)redirectUrl);
        String state = URLEncoder.encode(redirectUrl, "UTF-8");
        String uri = String.format("%s?client_id=%s&response_type=code&scope=/authenticate&redirect_uri=%s&state=%s", this.orcidAuthorizationUri, this.orcidClientId, this.orcidRedirectUri, state);
        response.sendRedirect(uri);
    }

    @GetMapping(value={"/redirect"})
    public void redirect(HttpServletRequest request, HttpServletResponse response, FederatedUser federatedUser, @RequestParam(value="code") String code, @RequestParam(value="state") String state) throws IOException {
        LOG.debug("Redirect from ORCID for {} with code {} and state {}", new Object[]{federatedUser.uid, code, state});
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.add((Object)"client_id", (Object)this.orcidClientId);
        map.add((Object)"client_secret", (Object)this.orcidClientSecret);
        map.add((Object)"grant_type", (Object)"authorization_code");
        map.add((Object)"code", (Object)code);
        map.add((Object)"redirect_uri", (Object)this.orcidRedirectUri);
        HttpEntity httpEntity = new HttpEntity((Object)map, (MultiValueMap)this.httpHeaders);
        ResponseEntity responseEntity = this.restTemplate.exchange(this.orcidAccessTokenUri, HttpMethod.POST, httpEntity, Map.class, new Object[0]);
        if (!responseEntity.getStatusCode().is2xxSuccessful()) {
            throw new IllegalArgumentException(String.format("Unable to exchange code for ORCID id {}", responseEntity));
        }
        String orcid = (String)String.class.cast(((Map)responseEntity.getBody()).get("orcid"));
        Optional accountOptional = this.accountRepository.findByUrnIgnoreCaseAndAccountType(federatedUser.uid, AccountType.ORCID);
        Account account = accountOptional.orElseGet(() -> new Account(federatedUser.uid, federatedUser.schacHomeOrganization, AccountType.ORCID));
        account.setLinkedId(orcid.startsWith("http") ? orcid : "http://orcid.org/".concat(orcid));
        this.accountRepository.save((Object)account);
        LOG.debug("Saved ORCID linked account {}", (Object)account);
        response.sendRedirect(state);
    }

    @GetMapping(value={"/internal/accounts/{urn:.+}"})
    public List<Account> accounts(@PathVariable(value="urn") String urn) {
        List accounts = this.accountRepository.findByUrnIgnoreCase(urn);
        LOG.debug("Accounts {} for {}", (Object)accounts, (Object)urn);
        return accounts;
    }

    @DeleteMapping(value={"/internal/disconnect/{id}"})
    public void disconnect(@PathVariable(value="id") Long id) {
        Account account = (Account)this.accountRepository.findOne((Serializable)id);
        if (account == null) {
            throw new ResourceNotFoundException(String.format("Account %s not found", id));
        }
        LOG.debug("Deleting account {}", (Object)account);
        this.accountRepository.delete((Object)account);
    }
}

