/*
 * Decompiled with CFR 0.152.
 */
package aa.aggregators;

import aa.aggregators.AttributeAggregator;
import aa.aggregators.PreemptiveAuthenticationHttpComponentsClientHttpRequestFactory;
import aa.model.AttributeAuthorityConfiguration;
import aa.model.RequiredInputAttribute;
import aa.model.UserAttribute;
import aa.util.StreamUtils;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

public abstract class AbstractAttributeAggregator
implements AttributeAggregator {
    protected final Logger LOG = LoggerFactory.getLogger(this.getClass());
    private final AttributeAuthorityConfiguration attributeAuthorityConfiguration;
    private final List<String> attributeKeysRequired;
    private RestTemplate restTemplate;

    public AbstractAttributeAggregator(AttributeAuthorityConfiguration attributeAuthorityConfiguration) {
        this.attributeAuthorityConfiguration = attributeAuthorityConfiguration;
        this.attributeKeysRequired = attributeAuthorityConfiguration.getRequiredInputAttributes().stream().map(RequiredInputAttribute::getName).collect(Collectors.toList());
        if (StringUtils.hasText((String)attributeAuthorityConfiguration.getEndpoint())) {
            this.restTemplate = this.initializeRestTemplate(attributeAuthorityConfiguration);
        }
    }

    protected RestTemplate initializeRestTemplate(AttributeAuthorityConfiguration attributeAuthorityConfiguration) {
        try {
            return new RestTemplate(this.getRequestFactory(attributeAuthorityConfiguration));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public List<String> attributeKeysRequired() {
        return this.attributeKeysRequired;
    }

    public Optional<String> cacheKey(List<UserAttribute> input) {
        List requiredKeys = this.attributeKeysRequired();
        Set values = input.stream().filter(userAttribute -> requiredKeys.contains(userAttribute.getName())).map(UserAttribute::getValues).flatMap(Collection::stream).collect(Collectors.toSet());
        return values.isEmpty() ? Optional.empty() : Optional.of(this.getAttributeAuthorityId() + "-" + String.join((CharSequence)",", values));
    }

    public String getAttributeAuthorityId() {
        return this.attributeAuthorityConfiguration.getId();
    }

    public AttributeAuthorityConfiguration getAttributeAuthorityConfiguration() {
        return this.attributeAuthorityConfiguration;
    }

    public RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    protected URI endpoint() {
        try {
            return new URI(this.attributeAuthorityConfiguration.getEndpoint());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    protected String getUserAttributeSingleValue(List<UserAttribute> input, String nameId) {
        Optional userAttribute = (Optional)input.stream().filter(attr -> attr.getName().equals(nameId)).collect(StreamUtils.singletonOptionalCollector());
        if (!userAttribute.isPresent() || ((UserAttribute)userAttribute.get()).getValues().isEmpty()) {
            throw new IllegalArgumentException(String.format("%s requires %s attribute with value", this.getClass(), nameId));
        }
        return (String)((UserAttribute)userAttribute.get()).getValues().get(0);
    }

    protected List<UserAttribute> mapValuesToUserAttribute(String attributeName, List<String> values) {
        if (CollectionUtils.isEmpty(values)) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new UserAttribute(attributeName, values, this.getAttributeAuthorityId()));
    }

    private ClientHttpRequestFactory getRequestFactory(AttributeAuthorityConfiguration attributeAuthorityConfiguration) throws MalformedURLException {
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create().evictExpiredConnections().evictIdleConnections(10L, TimeUnit.SECONDS);
        if (StringUtils.hasText((String)attributeAuthorityConfiguration.getUser())) {
            BasicCredentialsProvider basicCredentialsProvider = new BasicCredentialsProvider();
            basicCredentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(attributeAuthorityConfiguration.getUser(), attributeAuthorityConfiguration.getPassword()));
            httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)basicCredentialsProvider);
        }
        int timeOut = attributeAuthorityConfiguration.getTimeOut();
        httpClientBuilder.setDefaultRequestConfig(RequestConfig.custom().setConnectionRequestTimeout(timeOut).setConnectTimeout(timeOut).setSocketTimeout(timeOut).build());
        CloseableHttpClient httpClient = httpClientBuilder.build();
        return new PreemptiveAuthenticationHttpComponentsClientHttpRequestFactory((HttpClient)httpClient, attributeAuthorityConfiguration.getEndpoint());
    }

    public String toString() {
        return String.format("AttributeAggregator with configuration: %s", this.attributeAuthorityConfiguration);
    }
}

