/*
 * Decompiled with CFR 0.152.
 */
package aa.aggregators.pseudo;

import aa.repository.PseudoEmailRepository;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class PseudoEmailRetentionPeriodCleaner {
    private static final Logger LOG = LoggerFactory.getLogger(PseudoEmailRetentionPeriodCleaner.class);
    private final PseudoEmailRepository pseudoEmailRepository;
    private final int retentionPeriodDays;

    @Autowired
    public PseudoEmailRetentionPeriodCleaner(@Value(value="${pseudo_emails_retention_days_period}") int retentionPeriodDays, PseudoEmailRepository pseudoEmailRepository, @Value(value="${cron_job_responsible}") boolean cronJobResponsible) {
        this.pseudoEmailRepository = pseudoEmailRepository;
        this.retentionPeriodDays = retentionPeriodDays;
        if (cronJobResponsible) {
            Executors.newScheduledThreadPool(1).scheduleAtFixedRate(() -> this.clean(), 0L, 1L, TimeUnit.DAYS);
        }
    }

    protected int clean() {
        LOG.info("Start deleting inactive pseudo emailsolder then {} days.", (Object)this.retentionPeriodDays);
        int deleted = this.pseudoEmailRepository.deleteOlderThenRetentionDays(this.retentionPeriodDays);
        LOG.info("Finished deleting pseudo emails older then {} days. Deleted {} pseudo emails", (Object)this.retentionPeriodDays, (Object)deleted);
        return deleted;
    }
}

