/*
 * Decompiled with CFR 0.152.
 */
package aa.aggregators.idin;

import aa.aggregators.AbstractAttributeAggregator;
import aa.aggregators.PrePopulatedJsonHttpHeaders;
import aa.model.AttributeAuthorityConfiguration;
import aa.model.UserAttribute;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.http.HttpMethod;
import org.springframework.http.RequestEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;

public class IdinAttributeAggregator
extends AbstractAttributeAggregator {
    private final PrePopulatedJsonHttpHeaders headers = new PrePopulatedJsonHttpHeaders();

    public IdinAttributeAggregator(AttributeAuthorityConfiguration attributeAuthorityConfiguration) {
        super(attributeAuthorityConfiguration);
    }

    public List<UserAttribute> aggregate(List<UserAttribute> input) {
        String unspecifiedId = this.getUserAttributeSingleValue(input, "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified");
        URI uri = this.uri(unspecifiedId);
        this.LOG.debug("Retrieving iDEN with request: {}", (Object)uri);
        Map body = this.getUserMap(uri);
        this.LOG.debug("Retrieved iDEN with response: {}", (Object)body);
        if (body.isEmpty()) {
            return new ArrayList<UserAttribute>();
        }
        String email = (String)body.get("email");
        String affiliations = (String)body.get("affiliations");
        ArrayList<UserAttribute> userAttributes = new ArrayList<UserAttribute>();
        if (email != null) {
            userAttributes.add(new UserAttribute("urn:mace:dir:attribute-def:mail", Collections.singletonList(email), this.getAttributeAuthorityId()));
        }
        if (affiliations != null) {
            userAttributes.add(new UserAttribute("urn:mace:dir:attribute-def:eduPersonAffiliation", Arrays.asList(affiliations.split(", ")), this.getAttributeAuthorityId()));
        }
        userAttributes.add(new UserAttribute("urn:mace:dir:attribute-def:isMemberOf", Collections.singletonList("surf.nl"), this.getAttributeAuthorityId()));
        return userAttributes;
    }

    private Map<String, Object> getUserMap(URI uri) {
        try {
            RequestEntity requestEntity = new RequestEntity((MultiValueMap)this.headers, HttpMethod.GET, uri);
            return (Map)this.getRestTemplate().exchange(requestEntity, Map.class).getBody();
        }
        catch (HttpClientErrorException e) {
            if (e.getStatusCode().value() != 404) {
                throw e;
            }
            return Collections.EMPTY_MAP;
        }
    }

    private URI uri(String unspecifiedId) {
        try {
            return new URI(this.getAttributeAuthorityConfiguration().getEndpoint().concat("/").concat(unspecifiedId));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

