/*
 * Decompiled with CFR 0.152.
 */
package aa.aggregators.pseudo;

import aa.aggregators.AbstractAttributeAggregator;
import aa.model.AttributeAuthorityConfiguration;
import aa.model.PseudoEmail;
import aa.model.UserAttribute;
import aa.repository.PseudoEmailRepository;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;

public class PseudoEmailAggregator
extends AbstractAttributeAggregator {
    private String emailPostfix;
    private PseudoEmailRepository pseudoEmailRepository;

    public PseudoEmailAggregator(AttributeAuthorityConfiguration configuration, PseudoEmailRepository pseudoEmailRepository, String emailPostfix) {
        super(configuration);
        this.pseudoEmailRepository = pseudoEmailRepository;
        this.emailPostfix = emailPostfix;
    }

    public List<UserAttribute> aggregate(List<UserAttribute> input) {
        String spEntityId;
        String email = this.getUserAttributeSingleValue(input, "urn:mace:dir:attribute-def:mail");
        Optional emailOptional = this.pseudoEmailRepository.findByEmailAndSpEntityId(email, spEntityId = this.getUserAttributeSingleValue(input, "SPentityID"));
        PseudoEmail pseudoEmail = emailOptional.orElseGet(() -> new PseudoEmail(email, String.format("%s@%s", UUID.randomUUID().toString(), this.emailPostfix), spEntityId));
        boolean newPseudoEmail = pseudoEmail.getId() == null;
        this.LOG.debug("{} Pseudo email {}", (Object)(newPseudoEmail ? "New" : "Retrieved existing"), (Object)pseudoEmail);
        pseudoEmail.setUpdated(Instant.now());
        this.pseudoEmailRepository.save((Object)pseudoEmail);
        return this.mapValuesToUserAttribute("urn:mace:dir:attribute-def:mail", Collections.singletonList(pseudoEmail.getPseudoEmail()));
    }
}

