/*
 * Decompiled with CFR 0.152.
 */
package aa.aggregators.sab;

import aa.aggregators.AbstractAttributeAggregator;
import aa.aggregators.sab.SabInfoType;
import aa.aggregators.sab.SabResponseParser;
import aa.model.ArpValue;
import aa.model.AttributeAuthorityConfiguration;
import aa.model.UserAttribute;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.io.IOUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.springframework.core.io.ClassPathResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;

public class SabAttributeAggregator
extends AbstractAttributeAggregator {
    private static final DateTimeFormatter dateTimeFormatter = ISODateTimeFormat.dateTimeNoMillis().withZone(DateTimeZone.UTC);
    private final String template;
    private final SabResponseParser parser = new SabResponseParser();

    public SabAttributeAggregator(AttributeAuthorityConfiguration attributeAuthorityConfiguration) {
        super(attributeAuthorityConfiguration);
        try {
            this.template = IOUtils.toString((InputStream)new ClassPathResource("sab/request.xml").getInputStream(), (Charset)Charset.defaultCharset());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List<UserAttribute> aggregate(List<UserAttribute> input, Map<String, List<ArpValue>> arpAttributes) {
        Map result;
        String userId = this.getUserAttributeSingleValue(input, "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified");
        String request = this.request(userId);
        ResponseEntity response = this.getRestTemplate().exchange(this.endpoint(), HttpMethod.POST, new HttpEntity((Object)request), String.class);
        String body = null;
        try {
            body = ((String)response.getBody()).trim().replaceAll("[\\r\\n]+", "");
            result = this.parser.parse((Reader)new StringReader(body));
        }
        catch (XMLStreamException e) {
            this.LOG.warn("XMLStreamException while parsing. The XML '{}'", body);
            throw new RuntimeException(e);
        }
        this.LOG.debug("Retrieved SAB roles with request: {} and response: {}", (Object)request, (Object)response);
        List scopedValues = result.entrySet().stream().map(arg_0 -> this.sabInfoTypeList(arg_0)).flatMap(Collection::stream).collect(Collectors.toList());
        return this.mapValuesToUserAttribute("urn:mace:dir:attribute-def:eduPersonEntitlement", scopedValues);
    }

    private List<String> sabInfoTypeList(Map.Entry<SabInfoType, List<String>> entry) {
        SabInfoType sabInfoType = entry.getKey();
        List<String> values = entry.getValue();
        return values.stream().map(value -> value.startsWith("urn:mace:surfnet.nl:") ? value : sabInfoType.getPrefix().concat((String)value)).collect(Collectors.toList());
    }

    private String request(String userId) {
        String issueInstant = dateTimeFormatter.print(System.currentTimeMillis());
        return MessageFormat.format(this.template, UUID.randomUUID().toString(), issueInstant, userId);
    }
}

