/*
 * Decompiled with CFR 0.152.
 */
package aa.aggregators.rest;

import aa.aggregators.AbstractAttributeAggregator;
import aa.model.ArpValue;
import aa.model.AttributeAuthorityConfiguration;
import aa.model.PathParam;
import aa.model.UserAttribute;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;

public class RestAttributeAggregator
extends AbstractAttributeAggregator {
    private final ObjectMapper objectMapper = new ObjectMapper();

    public RestAttributeAggregator(AttributeAuthorityConfiguration attributeAuthorityConfiguration) {
        super(attributeAuthorityConfiguration);
    }

    public List<UserAttribute> aggregate(List<UserAttribute> input, Map<String, List<ArpValue>> arpAttributes) {
        AttributeAuthorityConfiguration configuration = this.getAttributeAuthorityConfiguration();
        String data = this.fetchData(input, configuration);
        return this.mapToAttributes(data, configuration);
    }

    private String fetchData(List<UserAttribute> attributes, AttributeAuthorityConfiguration configuration) {
        HttpMethod method;
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
        headers.setContentType(MediaType.APPLICATION_JSON);
        if (null != configuration.getHeaders()) {
            configuration.getHeaders().forEach(header -> headers.add(header.getKey(), header.getValue()));
        }
        String endpoint = configuration.getEndpoint();
        if (null != configuration.getPathParams()) {
            configuration.getPathParams().sort(Comparator.comparing(PathParam::getIndex));
            Object[] pathParamValues = configuration.getPathParams().stream().map(pathParam -> attributes.stream().filter(attribute -> attribute.getName().equals(pathParam.getSourceAttribute())).map(attribute -> (String)attribute.getValues().get(0)).collect(Collectors.toList())).flatMap(Collection::stream).toArray();
            endpoint = String.format(endpoint, pathParamValues);
        }
        UriComponentsBuilder builder = UriComponentsBuilder.fromUriString((String)endpoint);
        if (null != configuration.getRequestParams()) {
            configuration.getRequestParams().forEach(requestParam -> attributes.stream().filter(attribute -> attribute.getName().equals(requestParam.getSourceAttribute())).findFirst().ifPresent(param -> builder.queryParam(requestParam.getName(), new Object[]{param.getValues().get(0)})));
        }
        if (null == (method = HttpMethod.resolve((String)configuration.getRequestMethod()))) {
            this.LOG.info("Can not resolve unknown HTTP method: {}, defaulting to GET", (Object)configuration.getRequestMethod());
            method = HttpMethod.GET;
        }
        return (String)this.getRestTemplate().exchange(builder.toUriString(), method, new HttpEntity(null, (MultiValueMap)headers), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]).getBody();
    }

    private List<UserAttribute> mapToAttributes(String data, AttributeAuthorityConfiguration configuration) {
        JsonNode node;
        ArrayList<UserAttribute> result = new ArrayList<UserAttribute>();
        if (null == configuration.getMappings() || configuration.getMappings().isEmpty()) {
            this.LOG.warn("No configured mappings found for retrieved data from REST endpoint, returning empty enriched attribute list");
            return result;
        }
        try {
            node = this.objectMapper.readTree(data);
        }
        catch (JsonProcessingException exception) {
            this.LOG.warn("Can not parse response from REST endpoint, returning empty enriched attribute list");
            exception.printStackTrace();
            return result;
        }
        configuration.getMappings().forEach(mapping -> {
            JsonNode jsonNode = node.findValue(mapping.getResponseKey());
            if (null != jsonNode) {
                result.add(this.createAttribute(configuration.getId(), mapping.getTargetAttribute(), jsonNode.asText()));
            }
        });
        return result;
    }

    private UserAttribute createAttribute(String sourceId, String key, String value) {
        UserAttribute attribute = new UserAttribute();
        attribute.setName(key);
        attribute.setValues(List.of(value));
        attribute.setSource(sourceId);
        return attribute;
    }
}

