/*
 * Decompiled with CFR 0.152.
 */
package aa.aggregators.rest;

import aa.aggregators.AbstractAttributeAggregator;
import aa.model.ArpValue;
import aa.model.AttributeAuthorityConfiguration;
import aa.model.MappingFilter;
import aa.model.PathParam;
import aa.model.UserAttribute;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.restassured.path.json.JsonPath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponentsBuilder;

public class RestAttributeAggregator
extends AbstractAttributeAggregator {
    private final ObjectMapper objectMapper = new ObjectMapper();

    public RestAttributeAggregator(AttributeAuthorityConfiguration attributeAuthorityConfiguration) {
        super(attributeAuthorityConfiguration);
    }

    public List<UserAttribute> aggregate(List<UserAttribute> input, Map<String, List<ArpValue>> arpAttributes) {
        AttributeAuthorityConfiguration configuration = this.getAttributeAuthorityConfiguration();
        String data = this.fetchData(input, configuration);
        return this.mapToAttributes(data, configuration);
    }

    private String fetchData(List<UserAttribute> attributes, AttributeAuthorityConfiguration configuration) {
        HttpMethod method;
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
        headers.setContentType(MediaType.APPLICATION_JSON);
        if (null != configuration.getHeaders()) {
            configuration.getHeaders().forEach(header -> headers.add(header.getKey(), header.getValue()));
        }
        if (configuration.getUser() != null && configuration.getPassword() != null) {
            headers.setBasicAuth(configuration.getUser(), configuration.getPassword());
        }
        String endpoint = configuration.getEndpoint();
        if (null != configuration.getPathParams()) {
            configuration.getPathParams().sort(Comparator.comparing(PathParam::getIndex));
            Object[] pathParamValues = configuration.getPathParams().stream().map(pathParam -> attributes.stream().filter(attribute -> attribute.getName().equals(pathParam.getSourceAttribute())).map(attribute -> (String)attribute.getValues().get(0)).collect(Collectors.toList())).flatMap(Collection::stream).toArray();
            endpoint = String.format(endpoint, pathParamValues);
        }
        UriComponentsBuilder builder = UriComponentsBuilder.fromUriString((String)endpoint);
        if (null != configuration.getRequestParams()) {
            configuration.getRequestParams().forEach(requestParam -> attributes.stream().filter(attribute -> attribute.getName().equals(requestParam.getSourceAttribute())).findFirst().ifPresent(param -> builder.queryParam(requestParam.getName(), new Object[]{param.getValues().get(0)})));
        }
        if (null == (method = HttpMethod.resolve((String)configuration.getRequestMethod()))) {
            this.LOG.info("Can not resolve unknown HTTP method: {}, defaulting to GET", (Object)configuration.getRequestMethod());
            method = HttpMethod.GET;
        }
        return (String)this.getRestTemplate().exchange(builder.toUriString(), method, new HttpEntity(null, (MultiValueMap)headers), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]).getBody();
    }

    private List<UserAttribute> mapToAttributes(String data, AttributeAuthorityConfiguration configuration) {
        List<Map> rootList;
        if (CollectionUtils.isEmpty((Collection)configuration.getMappings())) {
            throw new IllegalArgumentException("No configured mappings found for retrieved data from REST endpoint, returning empty enriched attribute list");
        }
        ArrayList result = new ArrayList();
        try {
            Object obj = this.objectMapper.readValue(data, Object.class);
            if (StringUtils.hasText((String)configuration.getRootListName())) {
                obj = JsonPath.from((String)data).get(configuration.getRootListName());
            }
            rootList = obj instanceof List ? (List<Map>)obj : List.of((Map)obj);
        }
        catch (JsonProcessingException exception) {
            this.LOG.error("Can not parse response from REST endpoint, returning empty enriched attribute list", (Throwable)exception);
            return Collections.emptyList();
        }
        rootList.forEach(m -> configuration.getMappings().forEach(mapping -> {
            MappingFilter filter = mapping.getFilter();
            if (null != filter && StringUtils.hasText((String)filter.getKey()) && !filter.getValue().equals(m.get(filter.getKey()))) {
                return;
            }
            Object o = m.get(mapping.getResponseKey());
            if (o != null) {
                result.add(this.createAttribute(configuration.getId(), mapping.getTargetAttribute(), o.toString()));
            }
        }));
        Map<String, List<UserAttribute>> groupedBy = result.stream().collect(Collectors.groupingBy(UserAttribute::getName));
        return groupedBy.entrySet().stream().map(entry -> new UserAttribute((String)entry.getKey(), ((List)entry.getValue()).stream().map(UserAttribute::getValues).flatMap(Collection::stream).collect(Collectors.toList()), configuration.getId())).collect(Collectors.toList());
    }

    private UserAttribute createAttribute(String sourceId, String key, String value) {
        UserAttribute attribute = new UserAttribute();
        attribute.setName(key);
        attribute.setValues(List.of(value));
        attribute.setSource(sourceId);
        return attribute;
    }
}

