/*
 * Decompiled with CFR 0.152.
 */
package aa.aggregators.ala;

import aa.aggregators.AbstractAttributeAggregator;
import aa.model.ArpValue;
import aa.model.AttributeAuthorityConfiguration;
import aa.model.UserAttribute;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.util.MultiValueMap;

public abstract class AbstractAlaAttributeAggregator
extends AbstractAttributeAggregator {
    private HttpHeaders httpHeaders = new HttpHeaders();

    public AbstractAlaAttributeAggregator(AttributeAuthorityConfiguration attributeAuthorityConfiguration) {
        super(attributeAuthorityConfiguration);
        this.httpHeaders.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
        this.httpHeaders.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
    }

    public List<UserAttribute> aggregate(List<UserAttribute> input, Map<String, List<ArpValue>> arpAttributes) {
        String eduPersonPrincipalName = this.getUserAttributeSingleValue(input, "urn:mace:dir:attribute-def:eduPersonPrincipalName");
        String spEntityId = this.getUserAttributeSingleValue(input, "SPentityID");
        String url = String.format("%s?eduperson_principal_name=%s&sp_entity_id=%s", this.getAttributeAuthorityConfiguration().getEndpoint(), this.decodeRequestParameters() ? this.encode(eduPersonPrincipalName) : eduPersonPrincipalName, this.decodeRequestParameters() ? this.encode(spEntityId) : spEntityId);
        List userAttributes = (List)this.getRestTemplate().exchange(url, HttpMethod.GET, new HttpEntity((MultiValueMap)this.httpHeaders), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]).getBody();
        List userAttributesNames = userAttributes.stream().map(UserAttribute::getName).collect(Collectors.toList());
        if (this.fallBackForMissingAttributesToUserAttributes()) {
            List arpKeys = arpAttributes.keySet().stream().filter(samlAttributeName -> !userAttributesNames.contains(samlAttributeName) && ((List)arpAttributes.get(samlAttributeName)).stream().anyMatch(arpValue -> this.arpSourceValue().equals(arpValue.getSource()))).collect(Collectors.toList());
            List preserve = input.stream().filter(userAttribute -> arpKeys.contains(userAttribute.getName())).collect(Collectors.toList());
            userAttributes.addAll(preserve);
        }
        userAttributes.forEach(userAttribute -> userAttribute.setSource(this.getAttributeAuthorityId()));
        return userAttributes;
    }

    public List<UserAttribute> filterInvalidResponses(List<UserAttribute> input) {
        return input;
    }

    public abstract String arpSourceValue();

    public abstract boolean decodeRequestParameters();

    public abstract boolean fallBackForMissingAttributesToUserAttributes();
}

