/*
 * Decompiled with CFR 0.152.
 */
package aa.aggregators;

import aa.aggregators.AttributeAggregator;
import aa.aggregators.ala.AlaAttributeAggregator;
import aa.aggregators.eduid.EduIdAttributeAggregator;
import aa.aggregators.entitlements.EntitlementsAggregator;
import aa.aggregators.idin.IdinAttributeAggregator;
import aa.aggregators.manage.SurfCrmAttributeAggregator;
import aa.aggregators.orcid.OrcidAttributeAggregator;
import aa.aggregators.pseudo.PseudoEmailAggregator;
import aa.aggregators.rest.RestAttributeAggregator;
import aa.aggregators.sab.SabAttributeAggregator;
import aa.aggregators.sabrest.SabRestAttributeAggregator;
import aa.aggregators.sbs.SBSAttributeAggregator;
import aa.aggregators.test.TestingAttributeAggregator;
import aa.aggregators.voot.VootAttributeAggregator;
import aa.cache.UserAttributeCache;
import aa.config.AuthorityConfiguration;
import aa.config.AuthorityResolver;
import aa.model.AggregatorType;
import aa.model.AttributeAuthorityConfiguration;
import aa.repository.AccountRepository;
import aa.repository.PseudoEmailRepository;
import aa.service.AttributeAggregatorService;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.support.CronTrigger;

@Configuration
public class AttributeAggregatorConfiguration {
    private final String authorizationAccessTokenUrl;
    private final String pseudoMailPostfix;
    private final AuthorityResolver authorityResolver;
    private final UserAttributeCache userAttributeCache;
    private final AccountRepository accountRepository;
    private final PseudoEmailRepository pseudoEmailRepository;
    private final TaskScheduler taskScheduler;

    @Autowired
    public AttributeAggregatorConfiguration(@Value(value="${authorization_access_token_url}") String authorizationAccessTokenUrl, @Value(value="${pseudo.mail_postfix}") String pseudoMailPostfix, AuthorityResolver authorityResolver, UserAttributeCache userAttributeCache, AccountRepository accountRepository, PseudoEmailRepository pseudoEmailRepository, TaskScheduler taskScheduler) {
        this.authorizationAccessTokenUrl = authorizationAccessTokenUrl;
        this.pseudoMailPostfix = pseudoMailPostfix;
        this.authorityResolver = authorityResolver;
        this.userAttributeCache = userAttributeCache;
        this.accountRepository = accountRepository;
        this.pseudoEmailRepository = pseudoEmailRepository;
        this.taskScheduler = taskScheduler;
    }

    @Bean
    @Profile(value={"test"})
    public AttributeAggregatorService testingAttributeAggregatorService() {
        return this.getAttributeAggregatorService(TestingAttributeAggregator::new);
    }

    @Bean
    @Profile(value={"!test"})
    public AttributeAggregatorService attributeAggregatorService() {
        return this.getAttributeAggregatorService(arg_0 -> this.attributeAggregatorById(arg_0));
    }

    private AttributeAggregatorService getAttributeAggregatorService(Function<AttributeAuthorityConfiguration, AttributeAggregator> aggregatorFunction) {
        AuthorityConfiguration configuration = this.authorityResolver.getConfiguration();
        List attributeAggregators = configuration.getAuthorities().stream().map(aggregatorFunction).filter(Objects::nonNull).collect(Collectors.toList());
        return new AttributeAggregatorService(attributeAggregators, configuration, this.userAttributeCache);
    }

    private AttributeAggregator attributeAggregatorById(AttributeAuthorityConfiguration configuration) {
        String id;
        switch (id = configuration.getId()) {
            case "sab": {
                return new SabAttributeAggregator(configuration);
            }
            case "voot": {
                return new VootAttributeAggregator(configuration, this.authorizationAccessTokenUrl);
            }
            case "orcid": {
                return new OrcidAttributeAggregator(configuration, this.accountRepository);
            }
            case "idin": {
                return new IdinAttributeAggregator(configuration);
            }
            case "pseudo_email": {
                return new PseudoEmailAggregator(configuration, this.pseudoEmailRepository, this.pseudoMailPostfix);
            }
            case "surfmarket_entitlements": {
                return new EntitlementsAggregator(configuration);
            }
            case "sbs": {
                return new SBSAttributeAggregator(configuration);
            }
            case "ala": {
                return new AlaAttributeAggregator(configuration);
            }
            case "eduid": {
                return new EduIdAttributeAggregator(configuration);
            }
            case "manage": {
                return new SurfCrmAttributeAggregator(configuration);
            }
            case "sabrest": {
                return new SabRestAttributeAggregator(configuration);
            }
        }
        if (id.startsWith("test:")) {
            return new TestingAttributeAggregator(configuration);
        }
        if (null != configuration.getType() && AggregatorType.rest.equals((Object)configuration.getType())) {
            RestAttributeAggregator restAggregator = new RestAttributeAggregator(configuration);
            if (restAggregator.cachingEnabled()) {
                this.taskScheduler.schedule((Runnable)restAggregator, (Trigger)new CronTrigger(configuration.getCache().getRefreshCron()));
            }
            return restAggregator;
        }
        return null;
    }
}

