/*
 * Decompiled with CFR 0.152.
 */
package aa.aggregators.rest;

import aa.aggregators.AbstractAttributeAggregator;
import aa.model.ArpValue;
import aa.model.AttributeAuthorityConfiguration;
import aa.model.Cache;
import aa.model.CacheFilter;
import aa.model.Header;
import aa.model.MappingFilter;
import aa.model.PathParam;
import aa.model.RequestParam;
import aa.model.UserAttribute;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.restassured.path.json.JsonPath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestClientException;
import org.springframework.web.util.UriComponentsBuilder;

public class RestAttributeAggregator
extends AbstractAttributeAggregator
implements Runnable {
    private static final String emptyResponse = "[]";
    private final ObjectMapper objectMapper = new ObjectMapper();
    boolean cacheUsed = false;
    private String cacheData;

    public RestAttributeAggregator(AttributeAuthorityConfiguration attributeAuthorityConfiguration) {
        super(attributeAuthorityConfiguration);
    }

    public List<UserAttribute> aggregate(List<UserAttribute> input, Map<String, List<ArpValue>> arpAttributes) {
        this.cacheUsed = false;
        AttributeAuthorityConfiguration configuration = this.getAttributeAuthorityConfiguration();
        String data = this.fetchData(input, configuration);
        return this.mapToAttributes(data, configuration, input);
    }

    @Override
    public void run() {
        if (this.cachingEnabled()) {
            AttributeAuthorityConfiguration configuration = this.getAttributeAuthorityConfiguration();
            this.LOG.debug("Refreshing cache for REST aggregator {}", (Object)configuration.getId());
            this.refreshCache(configuration);
        }
    }

    private String fetchData(List<UserAttribute> attributes, AttributeAuthorityConfiguration configuration) {
        try {
            return (String)this.doRequest(configuration.getHeaders(), configuration.getUser(), configuration.getPassword(), configuration.getEndpoint(), configuration.getPathParams(), attributes, configuration.getRequestParams(), configuration.getRequestMethod()).getBody();
        }
        catch (HttpStatusCodeException exception) {
            this.LOG.warn("Exception occurred during data retrieval for REST aggregator {}:", (Object)configuration.getId(), (Object)exception);
            if (!exception.getResponseBodyAsString().isEmpty()) {
                this.LOG.warn("Response body found for exception, returning response body");
                return exception.getResponseBodyAsString();
            }
            return this.handleException((RestClientException)((Object)exception), configuration);
        }
        catch (RestClientException exception) {
            this.LOG.warn("Exception occurred during data retrieval for REST aggregator {}:", (Object)configuration.getId(), (Object)exception);
            return this.handleException(exception, configuration);
        }
    }

    private ResponseEntity<String> doRequest(List<Header> configHeaders, String user, String password, String endpoint, List<PathParam> pathParams, List<UserAttribute> attributes, List<RequestParam> requestParams, String requestMethod) {
        HttpMethod method;
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
        headers.setContentType(MediaType.APPLICATION_JSON);
        if (null != configHeaders) {
            configHeaders.forEach(header -> headers.add(header.getKey(), header.getValue()));
        }
        if (user != null && password != null) {
            headers.setBasicAuth(user, password);
        }
        if (null != pathParams) {
            pathParams.sort(Comparator.comparing(PathParam::getIndex));
            Object[] pathParamValues = pathParams.stream().map(pathParam -> attributes.stream().filter(attribute -> attribute.getName().equals(pathParam.getSourceAttribute())).map(attribute -> (String)attribute.getValues().get(0)).collect(Collectors.toList())).flatMap(Collection::stream).toArray();
            endpoint = String.format(endpoint, pathParamValues);
        }
        UriComponentsBuilder builder = UriComponentsBuilder.fromUriString((String)endpoint);
        if (null != requestParams) {
            requestParams.forEach(requestParam -> attributes.stream().filter(attribute -> attribute.getName().equals(requestParam.getSourceAttribute())).findFirst().ifPresent(param -> builder.queryParam(requestParam.getName(), new Object[]{param.getValues().get(0)})));
        }
        if (null == (method = HttpMethod.resolve((String)requestMethod))) {
            this.LOG.info("Can not resolve unknown HTTP method: {}, defaulting to GET", (Object)requestMethod);
            method = HttpMethod.GET;
        }
        return this.getRestTemplate().exchange(builder.toUriString(), method, new HttpEntity(null, (MultiValueMap)headers), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
    }

    private List<UserAttribute> mapToAttributes(String data, AttributeAuthorityConfiguration configuration, List<UserAttribute> input) {
        if (CollectionUtils.isEmpty((Collection)configuration.getMappings())) {
            throw new IllegalArgumentException("No configured mappings found for retrieved data from REST endpoint, returning empty enriched attribute list");
        }
        ArrayList result = new ArrayList();
        List rootList = this.searchRootElement(data, configuration, input);
        if (rootList.isEmpty() && Boolean.TRUE.equals(configuration.getHandleResponseErrorAsEmpty())) {
            configuration.getMappings().forEach(mapping -> result.add(this.createAttribute(configuration.getId(), mapping.getTargetAttribute(), "")));
        } else {
            rootList.forEach(m -> configuration.getMappings().forEach(mapping -> {
                MappingFilter filter = mapping.getFilter();
                if (null != filter && StringUtils.hasText((String)filter.getKey()) && !filter.getValue().equals(m.get(filter.getKey()))) {
                    return;
                }
                Object o = m.get(mapping.getResponseKey());
                if (o != null) {
                    result.add(this.createAttribute(configuration.getId(), mapping.getTargetAttribute(), o.toString()));
                }
            }));
        }
        Map<String, List<UserAttribute>> groupedBy = result.stream().collect(Collectors.groupingBy(UserAttribute::getName));
        return groupedBy.entrySet().stream().map(entry -> new UserAttribute((String)entry.getKey(), ((List)entry.getValue()).stream().map(UserAttribute::getValues).flatMap(Collection::stream).sorted().toList(), configuration.getId())).collect(Collectors.toList());
    }

    private List<Map<String, Object>> searchRootElement(String data, AttributeAuthorityConfiguration configuration, List<UserAttribute> input) {
        List<Map<String, Object>> rootList;
        try {
            Object obj = this.objectMapper.readValue(data, Object.class);
            if (this.cacheUsed) {
                String cacheRootList = configuration.getCache().getRootListName();
                List cacheFilters = configuration.getCache().getFilters();
                if (null != cacheFilters && !cacheFilters.isEmpty()) {
                    cacheFilters.sort(Comparator.comparing(CacheFilter::getIndex));
                    for (CacheFilter cacheFilter : cacheFilters) {
                        String filterKey = cacheFilter.getKey();
                        UserAttribute filterAttribute = input.stream().filter(attribute -> attribute.getName().equals(cacheFilter.getSourceAttribute())).findFirst().orElse(null);
                        String filterValue = null != filterAttribute ? (String)filterAttribute.getValues().get(0) : null;
                        if (null == filterValue) continue;
                        cacheRootList = String.format(cacheRootList, filterKey, filterValue);
                    }
                }
                obj = JsonPath.from((String)data).get(cacheRootList);
            } else if (StringUtils.hasText((String)configuration.getRootListName())) {
                obj = JsonPath.from((String)data).get(configuration.getRootListName());
            }
            rootList = obj instanceof List ? (List<Map<String, Object>>)obj : List.of((Map)obj);
        }
        catch (JsonProcessingException | IllegalArgumentException | NullPointerException exception) {
            this.LOG.warn("Can not parse response from REST endpoint of {}, treating as empty response", (Object)configuration.getId(), (Object)exception);
            return Collections.emptyList();
        }
        return rootList;
    }

    private UserAttribute createAttribute(String sourceId, String key, String value) {
        UserAttribute attribute = new UserAttribute();
        attribute.setName(key);
        attribute.setValues(List.of(value));
        attribute.setSource(sourceId);
        return attribute;
    }

    private void refreshCache(AttributeAuthorityConfiguration configuration) {
        try {
            Cache cache = configuration.getCache();
            this.cacheData = (String)this.doRequest(cache.getHeaders(), configuration.getUser(), configuration.getPassword(), cache.getEndpoint(), null, null, null, cache.getRequestMethod()).getBody();
        }
        catch (RestClientException exception) {
            this.LOG.warn("Failed to retrieve cache data", (Throwable)exception);
        }
    }

    private String handleException(RestClientException exception, AttributeAuthorityConfiguration configuration) {
        if (this.cachingEnabled()) {
            this.LOG.info("Cache configuration found and enabled, returning cache data");
            this.cacheUsed = true;
            return this.cacheData;
        }
        if (Boolean.TRUE.equals(configuration.getHandleResponseErrorAsEmpty())) {
            this.LOG.info("Exception thrown but configured to handle as empty data, returning empty data");
            return emptyResponse;
        }
        throw exception;
    }
}

