/*
 * Decompiled with CFR 0.152.
 */
package aa.aggregators.sabrest;

import aa.aggregators.AbstractAttributeAggregator;
import aa.model.ArpValue;
import aa.model.AttributeAuthorityConfiguration;
import aa.model.UserAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;

public class SabRestAttributeAggregator
extends AbstractAttributeAggregator {
    private final String sabRestEndpoint;

    public SabRestAttributeAggregator(AttributeAuthorityConfiguration attributeAuthorityConfiguration) {
        super(attributeAuthorityConfiguration);
        Object endpointSab = this.getAttributeAuthorityConfiguration().getEndpoint();
        if (!((String)endpointSab).endsWith("/")) {
            endpointSab = (String)endpointSab + "/";
        }
        this.sabRestEndpoint = endpointSab = (String)endpointSab + "api/profile?uid={uid}&idp={idp}";
    }

    public List<UserAttribute> aggregate(List<UserAttribute> input, Map<String, List<ArpValue>> arpAttributes) {
        String uid = this.getUserAttributeSingleValue(input, "urn:mace:dir:attribute-def:uid");
        String idp = this.getUserAttributeSingleValue(input, "urn:mace:terena.org:attribute-def:schacHomeOrganization");
        Map result = (Map)this.getRestTemplate().getForObject(this.sabRestEndpoint, Map.class, new Object[]{uid, idp});
        if (!result.containsKey("message") || !result.get("message").equals("OK")) {
            return Collections.emptyList();
        }
        List profiles = (List)result.get("profiles");
        if (CollectionUtils.isEmpty((Collection)profiles)) {
            return Collections.emptyList();
        }
        Map profile = (Map)profiles.get(0);
        ArrayList entitlements = new ArrayList();
        entitlements.addAll(this.getOrganisationEntitlements(profile));
        entitlements.addAll(this.getAuthorisationEntitlements(profile));
        if (CollectionUtils.isEmpty(entitlements)) {
            return Collections.emptyList();
        }
        ArrayList<UserAttribute> userAttributes = new ArrayList<UserAttribute>();
        if (arpAttributes.containsKey("urn:mace:dir:attribute-def:eduPersonEntitlement")) {
            userAttributes.add(new UserAttribute("urn:mace:dir:attribute-def:eduPersonEntitlement", entitlements.stream().sorted().collect(Collectors.toList()), this.getAttributeAuthorityId()));
        }
        if (arpAttributes.containsKey("urn:mace:surf.nl:attribute-def:surf-autorisaties")) {
            userAttributes.add(new UserAttribute("urn:mace:surf.nl:attribute-def:surf-autorisaties", entitlements.stream().sorted().collect(Collectors.toList()), this.getAttributeAuthorityId()));
        }
        return userAttributes;
    }

    private List<String> getOrganisationEntitlements(Map<String, Object> profile) {
        if (profile.containsKey("organisation")) {
            Map organisation = (Map)profile.get("organisation");
            return Map.of("abbrev", "urn:mace:surfnet.nl:surfnet.nl:sab:organizationCode:", "guid", "urn:mace:surfnet.nl:surfnet.nl:sab:organizationGUID:").entrySet().stream().filter(entry -> organisation.containsKey(entry.getKey())).map(entry -> (String)entry.getValue() + (String)organisation.get(entry.getKey())).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    private List<String> getAuthorisationEntitlements(Map<String, Object> profile) {
        if (profile.containsKey("authorisations")) {
            List authorisations = (List)profile.get("authorisations");
            return authorisations.stream().map(m -> "urn:mace:surfnet.nl:surfnet.nl:sab:role:" + (String)m.get("role")).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }
}

