/*
 * Decompiled with CFR 0.152.
 */
package authzadmin;

import authzadmin.OauthSettings;
import authzadmin.Scope;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import org.springframework.security.oauth2.provider.client.BaseClientDetails;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class OauthClientDetails
extends BaseClientDetails {
    public static final String AUTO_APPROVE_SCOPE = "true";

    public OauthClientDetails(OauthSettings oauthSettings) {
        super(oauthSettings.getConsumerKey(), null, CollectionUtils.isEmpty(oauthSettings.getScopes()) ? null : StringUtils.collectionToCommaDelimitedString((Collection)oauthSettings.getScopes().stream().map(Scope::getValue).collect(Collectors.toList())), "authorization_code,refresh_token,implicit", null, oauthSettings.getCallbackUrl());
        this.setClientSecret(oauthSettings.getSecret());
        if (oauthSettings.isAutoApprove()) {
            this.setAutoApproveScopes(Arrays.asList(AUTO_APPROVE_SCOPE));
        }
    }
}

