/*
 * Decompiled with CFR 0.152.
 */
package authzadmin.web;

import authzadmin.OauthClientDetails;
import authzadmin.OauthSettings;
import authzadmin.web.BaseController;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.oauth2.provider.ClientAlreadyExistsException;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientRegistrationService;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/create"})
public class CreateController
extends BaseController {
    @Autowired
    private ClientRegistrationService clientRegistrationService;

    @RequestMapping(method={RequestMethod.GET})
    public ModelAndView get(OauthSettings oauthSettings) {
        return new ModelAndView("create");
    }

    @RequestMapping(method={RequestMethod.POST})
    public String post(@Valid OauthSettings oauthSettings, BindingResult bindingResult, RedirectAttributes redirectAttributes) {
        if (bindingResult.hasErrors()) {
            return "create";
        }
        try {
            this.transactionTemplate.execute(transactionStatus -> {
                this.clientRegistrationService.addClientDetails((ClientDetails)new OauthClientDetails(oauthSettings));
                return null;
            });
            this.notice(redirectAttributes, "create.success", new Object[0]);
            return "redirect:/";
        }
        catch (ClientAlreadyExistsException e) {
            bindingResult.rejectValue("consumerKey", "create.clientAlreadyExists");
            return "create";
        }
    }
}

