/*
 * Decompiled with CFR 0.152.
 */
package authzadmin;

import authzadmin.shibboleth.ShibbolethPreAuthenticatedProcessingFilter;
import authzadmin.shibboleth.ShibbolethUserDetailService;
import authzadmin.shibboleth.mock.MockShibbolethFilter;
import authzadmin.voot.EnsureAccessFilter;
import authzadmin.voot.VootClient;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.env.Environment;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.core.userdetails.AuthenticationUserDetailsService;
import org.springframework.security.oauth2.client.DefaultOAuth2ClientContext;
import org.springframework.security.oauth2.client.OAuth2ClientContext;
import org.springframework.security.oauth2.client.filter.OAuth2ClientContextFilter;
import org.springframework.security.oauth2.client.token.AccessTokenRequest;
import org.springframework.security.oauth2.client.token.DefaultAccessTokenRequest;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationProvider;

@Configuration
@EnableWebSecurity
public class ShibbolethSecurityConfig
extends WebSecurityConfigurerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(ShibbolethSecurityConfig.class);
    @Autowired
    private VootClient vootClient;
    @Autowired
    private Environment environment;
    @Value(value="${allowed_group}")
    private String allowedGroup;

    @Bean
    @Scope(value="request", proxyMode=ScopedProxyMode.INTERFACES)
    protected AccessTokenRequest accessTokenRequest(@Value(value="#{request.parameterMap}") Map<String, String[]> parameters, @Value(value="#{request.getAttribute('currentUri')}") String currentUri) {
        DefaultAccessTokenRequest request = new DefaultAccessTokenRequest(parameters);
        request.setCurrentUri(currentUri);
        return request;
    }

    public void configure(WebSecurity web) throws Exception {
        ((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)web.ignoring().antMatchers(new String[]{"/css/**"})).antMatchers(new String[]{"/javascripts/**"})).antMatchers(new String[]{"/health"});
    }

    protected void configure(HttpSecurity http) throws Exception {
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.addFilterBefore((Filter)new ShibbolethPreAuthenticatedProcessingFilter(this.authenticationManagerBean()), AbstractPreAuthenticatedProcessingFilter.class).addFilterBefore((Filter)new EnsureAccessFilter(this.vootClient, this.allowedGroup), ShibbolethPreAuthenticatedProcessingFilter.class).addFilterBefore((Filter)new OAuth2ClientContextFilter(), EnsureAccessFilter.class).authorizeRequests().anyRequest()).authenticated();
        if (this.environment.acceptsProfiles(new String[]{"dev"})) {
            http.addFilterBefore((Filter)new MockShibbolethFilter(), ShibbolethPreAuthenticatedProcessingFilter.class);
        }
    }

    protected void configure(AuthenticationManagerBuilder auth) throws Exception {
        LOG.info("Configuring AuthenticationManager with a PreAuthenticatedAuthenticationProvider");
        PreAuthenticatedAuthenticationProvider authenticationProvider = new PreAuthenticatedAuthenticationProvider();
        authenticationProvider.setPreAuthenticatedUserDetailsService((AuthenticationUserDetailsService)new ShibbolethUserDetailService());
        auth.authenticationProvider((AuthenticationProvider)authenticationProvider);
    }

    @Configuration
    protected static class OAuth2ClientContextConfiguration {
        @Resource
        @Qualifier(value="accessTokenRequest")
        private AccessTokenRequest accessTokenRequest;

        protected OAuth2ClientContextConfiguration() {
        }

        @Bean
        @Scope(value="session", proxyMode=ScopedProxyMode.INTERFACES)
        public OAuth2ClientContext oauth2ClientContext() {
            return new DefaultOAuth2ClientContext(this.accessTokenRequest);
        }
    }
}

